<?php
namespace wbb\page;
use wbb\data\board\Board;
use wbb\data\modification\log\ThreadLogModificationLogList;
use wbb\data\thread\Thread;
use wbb\system\WBBCore;
use wcf\page\SortablePage;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\WCF;

/**
 * Shows the thread log page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Page
 * 
 * @property	ThreadLogModificationLogList	$objectList
 */
class ThreadLogPage extends SortablePage implements IBoardPage, IThreadPage {
	/**
	 * board object
	 * @var	Board
	 */
	public $board;
	
	/**
	 * @inheritDoc
	 */
	public $defaultSortField = 'time';
	
	/**
	 * @inheritDoc
	 */
	public $defaultSortOrder = 'DESC';
	
	/**
	 * @inheritDoc
	 */
	public $objectListClassName = ThreadLogModificationLogList::class;
	
	/**
	 * thread id
	 * @var	integer
	 */
	public $threadID = 0;
	
	/**
	 * thread object
	 * @var	Thread
	 */
	public $thread;
	
	/**
	 * @inheritDoc
	 */
	public $validSortFields = ['logID', 'time', 'username'];
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['id'])) $this->threadID = intval($_REQUEST['id']);
		$this->thread = new Thread($this->threadID);
		if (!$this->thread->threadID || $this->thread->movedThreadID) {
			throw new IllegalLinkException();
		}
		
		$this->board = new Board($this->thread->boardID);
		if (!$this->board->canEditThreads()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @inheritDoc
	 */
	protected function initObjectList() {
		parent::initObjectList();
		
		$this->objectList->setThread($this->thread);
	}
	
	/**
	 * @inheritDoc
	 */
	public function readData() {
		parent::readData();
		
		// add breadcrumbs
		WBBCore::getInstance()->setLocation($this->board->getParentBoards(), $this->board, $this->thread);
	}
	
	/**
	 * @inheritDoc
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		WCF::getTPL()->assign([
			'board' => $this->board,
			'thread' => $this->thread,
			'searchThread' => true
		]);
		
		if (count($this->objectList) === 0) {
			@header('HTTP/1.1 404 Not Found');
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function getBoard() {
		return $this->board;
	}
	
	/**
	 * @see	IThreadPage::getThread()
	 * @since	5.0
	 */
	public function getThread() {
		return $this->thread;
	}
}
