<?php
namespace wbb\data\thread\form;
use wcf\data\DatabaseObject;
use wcf\data\ITitledObject;
use wcf\system\WCF;

/**
 * Represents a thread form.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2020 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Acp\Form
 * @since	5.3
 *
 * @property-read	integer		$formID		unique id of the form
 * @property-read	String		$title		title of the thread form
 */
class ThreadForm extends DatabaseObject implements ITitledObject {
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return WCF::getLanguage()->get($this->title);
	}
}
