<?php
namespace wbb\data\thread;
use wbb\data\board\Board;
use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\WCF;

/**
 * Represents a list of watched threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class WatchedThreadList extends ViewableThreadList {
	/**
	 * Creates a new WatchedThreadList object.
	 */
	public function __construct() {
		parent::__construct();
		
		$boardIDs = Board::getAccessibleBoardIDs();
		$privateBoardIDs = Board::getPrivateBoardIDs();
		if (empty($boardIDs) && empty($privateBoardIDs)) {
			$this->getConditionBuilder()->add('1=0');
		}
		else {
			$objectTypeID = UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.thread');
			
			// add conditions
			$this->sqlConditionJoins = "LEFT JOIN wbb".WCF_N."_thread thread ON (thread.threadID = user_object_watch.objectID)";
			
			$this->getConditionBuilder()->add('user_object_watch.objectTypeID = ?', [$objectTypeID]);
			$this->getConditionBuilder()->add('user_object_watch.userID = ?', [WCF::getUser()->userID]);
			$this->getConditionBuilder()->add('thread.isDeleted = 0 AND thread.isDisabled = 0');
			
			$this->applyBoardFilter();
		}
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function countObjects() {
		$sql = "SELECT	COUNT(*) AS count
			FROM	wcf".WCF_N."_user_object_watch user_object_watch
			".$this->sqlConditionJoins."
			".$this->getConditionBuilder()->__toString();
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute($this->getConditionBuilder()->getParameters());
		$row = $statement->fetchArray();
		return $row['count'];
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function readObjectIDs() {
		$sql = "SELECT	user_object_watch.objectID AS objectID
			FROM	wcf".WCF_N."_user_object_watch user_object_watch
				".$this->sqlConditionJoins."
				".$this->getConditionBuilder()->__toString()."
				".(!empty($this->sqlOrderBy) ? "ORDER BY ".$this->sqlOrderBy : '');
		$statement = WCF::getDB()->prepareStatement($sql, $this->sqlLimit, $this->sqlOffset);
		$statement->execute($this->getConditionBuilder()->getParameters());
		$this->objectIDs = $statement->fetchAll(\PDO::FETCH_COLUMN);
	}
}
