<?php
namespace wbb\data\thread;
use wbb\data\board\Board;

/**
 * Represents a list of unresolved threads.
 *
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 * @since	5.0
 */
class UnresolvedThreadList extends AccessibleThreadList {
	/**
	 * Creates a new UnresolvedThreadList object.
	 */
	public function __construct() {
		parent::__construct();
		
		$this->applyBoardFilter(false, ['canViewBoard', 'canEnterBoard'], function($board) {
			/** @var Board $board */
			return $board->enableMarkingAsDone;
		});
		
		$this->getConditionBuilder()->add('thread.isDone = 0');
	}
}
