<?php
namespace wbb\data\thread;
use wcf\system\user\UserProfileHandler;

/**
 * Represents a list of threads that contain unread posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class UnreadThreadList extends AccessibleThreadList {
	/**
	 * Creates a new UnreadThreadList object.
	 */
	public function __construct() {
		parent::__construct();
		
		$this->excludeReadThreads();
		
		if (!empty(UserProfileHandler::getInstance()->getIgnoredUsers())) {
			$this->getConditionBuilder()->add("(thread.userID IS NULL OR thread.userID NOT IN (?))", [UserProfileHandler::getInstance()->getIgnoredUsers()]);
		}
	}
}
