<?php
namespace wbb\data\thread;

/**
 * Represents a list of similar threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class SimilarThreadList extends ViewableThreadList {
	/**
	 * @inheritDoc
	 */
	public $sqlLimit = WBB_THREAD_SIMILAR_THREADS_COUNT;
	
	/**
	 * @inheritDoc
	 */
	public $sqlOrderBy = 'thread.lastPostTime DESC';
	
	/**
	 * @inheritDoc
	 */
	public $useQualifiedShorthand = false;
	
	/** @noinspection PhpMissingParentConstructorInspection */
	/**
	 * Creates a new SimilarThreadList object.
	 */
	public function __construct() {
		ThreadList::__construct();
		
		$this->sqlJoins = $this->sqlConditionJoins = "LEFT JOIN wbb".WCF_N."_thread thread ON (thread.threadID = thread_similar.similarThreadID)";
		
		// get avatars
		if (!empty($this->sqlSelects)) $this->sqlSelects .= ',';
		$this->sqlSelects .= "user_avatar.*, user_table.email, user_table.disableAvatar, user_table.enableGravatar, user_table.gravatarFileExtension";
		$this->sqlJoins .= " LEFT JOIN wcf".WCF_N."_user user_table ON (user_table.userID = thread.userID)";
		$this->sqlJoins .= " LEFT JOIN wcf".WCF_N."_user_avatar user_avatar ON (user_avatar.avatarID = user_table.avatarID)";
		
		$this->sqlSelects .= ', thread.*';
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function readObjectIDs() {
		// does nothing
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getDatabaseTableName() {
		return 'wbb'.WCF_N.'_thread_similar';
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function getDatabaseTableAlias() {
		return 'thread_similar';
	}
}
