<?php
namespace wbb\data\thread;

/**
 * Represents a list of search results.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class SearchResultThreadList extends ViewableThreadList {
	/**
	 * @inheritDoc
	 */
	public $decoratorClassName = SearchResultThread::class;
	
	/**
	 * Creates a new SearchResultThreadList object.
	 */
	public function __construct() {
		parent::__construct();
		
		if (!empty($this->sqlSelects)) $this->sqlSelects .= ',';
		$this->sqlSelects .= 'board.boardID, board.title, board.enableMarkingAsDone';
		$this->sqlJoins .= " LEFT JOIN wbb".WCF_N."_board board ON (board.boardID = thread.boardID)";
	}
}
