<?php
namespace wbb\data\thread;
use wbb\system\cache\builder\HotThreadsCacheBuilder;

/**
 * Represents a list of hot threads.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class HotThreadList extends MostActiveThreadList {
	/**
	 * The formula that determines the temperature of a thread.
	 * 
	 * Multiply with 1000000000000 to avoid floating point errors.
	 * 
	 * Note: Don't forget to update $sqlOrderBy as well, constant scalar expressions
	 *       are only supported as of PHP 5.6
	 */
	const TEMPERATURE_FORMULA = '((((thread.replies + .1) * 50 + thread.views) * 1000000000000) / POWER(UNIX_TIMESTAMP() - thread.time, 1.5))';
	
	/**
	 * timeframe to select threads from (in days)
	 */
	public $timeframe = 30;

	/**
	 * @inheritDoc
	 */
	public $sqlLimit = 5;
	
	/**
	 * @see	\wcf\data\DatabaseObjectList::$sqlOrderBy
	 * @see	\wbb\data\thread\HotActiveThreadList::TEMPERATURE_FORMULA
	 */
	public $sqlOrderBy = '((((thread.replies + .1) * 50 + thread.views) * 1000000000000) / POWER(UNIX_TIMESTAMP() - thread.time, 1.5)) DESC, thread.time DESC';
	
	/**
	 * @inheritDoc
	 */
	public $sqlSelects = self::TEMPERATURE_FORMULA;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function getThreadIDs($boardID) {
		return array_keys(HotThreadsCacheBuilder::getInstance()->getData($boardID ? ['boardID' => $boardID] : []));
	}
}
