<?php
namespace wbb\data\thread;
use wbb\data\board\BoardCache;
use wcf\system\language\LanguageFactory;
use wcf\system\WCF;

/**
 * Represents a list of threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 *
 * @method	FeedThread		current()
 * @method	FeedThread[]		getObjects()
 * @method	FeedThread|null		search($objectID)
 * @property	FeedThread[]		$objects
 */
class FeedThreadList extends ViewableThreadList {
	/**
	 * @inheritDoc
	 */
	public $decoratorClassName = FeedThread::class;
	
	/**
	 * Creates a new FeedThreadList object.
	 * 
	 * @param       integer[]       $boardIDs
	 * @param       integer[]       $privateBoardIDs
	 */
	public function __construct(array $boardIDs, array $privateBoardIDs = []) {
		parent::__construct();
		
		if (empty($privateBoardIDs)) {
			$this->getConditionBuilder()->add("thread.boardID IN (?)", [$boardIDs]);
		}
		else if (empty($boardIDs)) {
			$this->getConditionBuilder()->add("(thread.boardID IN (?) AND thread.userID = ?)", [$privateBoardIDs, WCF::getUser()->userID]);
		}
		else {
			$this->getConditionBuilder()->add("(thread.boardID IN (?) OR (thread.boardID IN (?) AND thread.userID = ?))", [$boardIDs, $privateBoardIDs, WCF::getUser()->userID]);
		}
		
		if (count($boardIDs) == 1) {
			$board = BoardCache::getInstance()->getBoard(reset($boardIDs));
			if (!$board->getModeratorPermission('canReadDeletedThread')) $this->getConditionBuilder()->add('thread.isDeleted = 0');
			if (!$board->getModeratorPermission('canEnableThread')) {
				if (WCF::getUser()->userID) {
					$this->getConditionBuilder()->add('(thread.isDisabled = 0 OR thread.userID = ?)', [WCF::getUser()->userID]);
				}
				else {
					$this->getConditionBuilder()->add('thread.isDisabled = 0');
				}
			}
		}
		else {
			if (!WCF::getSession()->getPermission('mod.board.canReadDeletedThread')) $this->getConditionBuilder()->add('thread.isDeleted = 0');
			if (!WCF::getSession()->getPermission('mod.board.canEnableThread')) {
				if (WCF::getUser()->userID) {
					$this->getConditionBuilder()->add('(thread.isDisabled = 0 OR thread.userID = ?)', [WCF::getUser()->userID]);
				}
				else {
					$this->getConditionBuilder()->add('thread.isDisabled = 0');
				}
			}
		}
		// apply language filter
		if (LanguageFactory::getInstance()->multilingualismEnabled() && count(WCF::getUser()->getLanguageIDs())) {
			$this->getConditionBuilder()->add('(thread.languageID IN (?) OR thread.languageID IS NULL)', [WCF::getUser()->getLanguageIDs()]);
		}
		
		$this->getConditionBuilder()->add('thread.movedThreadID IS NULL');
		
		// get first post message
		if (!empty($this->sqlSelects)) $this->sqlSelects .= ',';
		$this->sqlSelects .= "last_post.message";
		$this->sqlJoins .= " LEFT JOIN wbb".WCF_N."_post last_post ON (last_post.postID = thread.lastPostID)";
	}
}
