<?php
namespace wbb\data\thread;
use wbb\data\board\Board;
use wbb\data\modification\log\BoardModificationLogList;
use wcf\system\clipboard\ClipboardHandler;

/**
 * Represents a list of deleted threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class DeletedThreadList extends ViewableThreadList {
	/**
	 * @inheritDoc
	 */
	public function __construct() {
		parent::__construct();
		
		$boardIDs = array_intersect(Board::getAccessibleModeratorBoardIDs(['canReadDeletedThread']), Board::getAccessibleBoardIDs(['canViewBoard', 'canEnterBoard']));
		if (!empty($boardIDs)) $this->getConditionBuilder()->add('thread.boardID IN (?)', [$boardIDs]);
		else $this->getConditionBuilder()->add('1 = 0');
		$this->getConditionBuilder()->add('thread.isDeleted = ?', [1]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function readObjects() {
		parent::readObjects();
		
		// load deletion data
		if (count($this->getObjectIDs())) {
			$logList = new BoardModificationLogList();
			$logList->setThreadData($this->getObjectIDs(), 'trash');
			$logList->readObjects();
			
			foreach ($logList as $logEntry) {
				/** @var ViewableThread $thread */
				foreach ($this->objects as $thread) {
					if ($thread->threadID == $logEntry->objectID) {
						$thread->setLogEntry($logEntry);
					}
				}
			}
		}
	}
	
	/**
	 * Returns the number of marked items.
	 * 
	 * @return	integer
	 */
	public function getMarkedItems() {
		return ClipboardHandler::getInstance()->hasMarkedItems(ClipboardHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.thread'));
	}
}
