<?php
namespace wbb\data\thread;
use wcf\system\language\LanguageFactory;
use wcf\system\WCF;

/**
 * Represents a list of accessible threads.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Thread
 */
class AccessibleThreadList extends ViewableThreadList {
	/**
	 * Creates a new AccessibleThreadList object.
	 * 
	 * @param       boolean         $filterByAccessibleBoards
	 */
	public function __construct($filterByAccessibleBoards = true) {
		parent::__construct();
		
		if ($filterByAccessibleBoards) {
			$this->applyBoardFilter();
		}
		
		// add default conditions
		$this->getConditionBuilder()->add("thread.isDeleted = 0 AND thread.isDisabled = 0 AND thread.movedThreadID IS NULL");
		
		// apply language filter
		if (LanguageFactory::getInstance()->multilingualismEnabled() && count(WCF::getUser()->getLanguageIDs())) {
			$this->getConditionBuilder()->add('(thread.languageID IN (?) OR thread.languageID IS NULL)', [WCF::getUser()->getLanguageIDs()]);
		}
	}
}
