<?php
namespace wbb\data\rss\feed;
use wbb\system\label\object\RssFeedLabelObjectHandler;
use wcf\data\AbstractDatabaseObjectAction;
use wcf\data\IToggleAction;
use wcf\system\label\LabelHandler;

/**
 * Executes feed-related actions.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Rss\Feed
 * 
 * @method	RssFeedEditor[]		getObjects()
 * @method	RssFeedEditor		getSingleObject()
 */
class RssFeedAction extends AbstractDatabaseObjectAction implements IToggleAction {
	/**
	 * @inheritDoc
	 */
	protected $className = RssFeedEditor::class;
	
	/**
	 * @inheritDoc
	 */
	protected $permissionsDelete = ['admin.board.canManageRssFeed'];
	
	/**
	 * @inheritDoc
	 */
	protected $permissionsUpdate = ['admin.board.canManageRssFeed'];
	
	/**
	 * @inheritDoc
	 */
	protected $requireACP = ['delete', 'toggle', 'update'];
	
	/**
	 * @inheritDoc
	 * @return	RssFeed
	 */
	public function create() {
		/** @var RssFeed $feed */
		$feed = parent::create();
		
		if (!empty($this->parameters['labelIDs'])) {
			RssFeedLabelObjectHandler::getInstance()->setLabels($this->parameters['labelIDs'], $feed->feedID);
		}
		
		return $feed;
	}
	
	/**
	 * @inheritDoc
	 */
	public function update() {
		parent::update();
		
		$labelIDs = [];
		if (!empty($this->parameters['labelIDs'])) {
			$labelIDs = $this->parameters['labelIDs'];
		}
		
		foreach ($this->getObjects() as $feed) {
			RssFeedLabelObjectHandler::getInstance()->setLabels($labelIDs, $feed->feedID);
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function delete() {
		$count = parent::delete();
		
		// delete label assignments
		if (!empty($this->objectIDs)) {
			LabelHandler::getInstance()->removeLabels(LabelHandler::getInstance()->getObjectType('com.woltlab.wbb.rssFeed')->objectTypeID, $this->objectIDs);
		}
		
		return $count;
	}
	
	/**
	 * @inheritDoc
	 */
	public function validateToggle() {
		parent::validateUpdate();
	}
	
	/**
	 * @inheritDoc
	 */
	public function toggle() {
		foreach ($this->getObjects() as $feed) {
			$feed->update([
				'isDisabled' => $feed->isDisabled ? 0 : 1
			]);
		}
	}
}
