<?php
namespace wbb\data\rss\feed;
use wcf\data\DatabaseObject;

/**
 * Represents a rss feed.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Rss\Feed
 * 
 * @property-read	integer		$feedID			unique id of the rss feed
 * @property-read	string		$title			title of the rss feed
 * @property-read	string		$url			url of the rss feed
 * @property-read	integer		$isDisabled		is 1 if rss feed is disabled so that no entries will be fetched, otherwise 0
 * @property-read	integer		$lastRun		timestamp at which the entries have been fetched the last time
 * @property-read	integer		$cycleTime		number of minutes after which the rss feed will be read again
 * @property-read	integer		$maxResults		maximum number of entries read at once while fetching new entries
 * @property-read	string		$searchKeywords		keywords the rss feed entries have to contain to be imported
 * @property-read	integer|null	$boardID		id of the board in which the rss feed entries will be posted or null if board has been deleted
 * @property-read	integer|null	$userID			id of the user which will be used to create the threads or null if user has been deleted
 * @property-read	integer|null	$languageID		id of the rss feed's language or null if no language is set
 * @property-read	integer		$closeThread		is 1 if created rss feed threads will automatically be closed after creation, otherwise 0
 * @property-read	integer		$disableThread		is 1 if created rss feed threads will automatically be disabled after creation, otherwise 0
 * @property-read	string		$threadTags		comma separated list of tags that will be assigned to the created rss feed thread
 * @property-read	integer		$useCategoriesAsTags	is 1 if the rss feed entries' categories will be used as tags, otherwise 0
 */
class RssFeed extends DatabaseObject {}
