<?php
namespace wbb\data\post;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\TUserContent;
use wcf\system\infraction\warning\IWarnableObject;

/**
 * Warnable object implementation for posts.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Post
 * 
 * @method	Post	getDecoratedObject()
 * @mixin	Post
 */
class WarnablePost extends DatabaseObjectDecorator implements IWarnableObject {
	use TUserContent;
	
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = Post::class;
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return $this->getDecoratedObject()->getTitle();
	}
	
	/**
	 * @inheritDoc
	 */
	public function getLink() {
		return $this->getDecoratedObject()->getLink();
	}
}
