<?php
namespace wbb\data\modification\log;
use wcf\data\modification\log\ModificationLog;
use wcf\data\DatabaseObjectDecorator;
use wcf\system\WCF;

/**
 * Provides a viewable thread modification log within board page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Modification\Log
 * 
 * @method	ModificationLog		getDecoratedObject()
 * @mixin	ModificationLog
 */
class ViewableBoardThreadModificationLog extends DatabaseObjectDecorator {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = ModificationLog::class;
	
	/**
	 * Returns readable representation of current log entry.
	 * 
	 * @return	string
	 */
	public function __toString() {
		return WCF::getLanguage()->getDynamicVariable('wbb.thread.log.thread.'.$this->action.'.summary', [
			'additionalData' => $this->additionalData,
			'time' => $this->time,
			'userID' => $this->userID,
			'username' => $this->username
		]);
	}
}
