<?php
namespace wbb\data\modification\log;
use wbb\system\log\modification\PostModificationLogHandler;
use wcf\data\modification\log\ModificationLogList;
use wcf\system\cache\runtime\UserProfileRuntimeCache;

/**
 * Represents a list of modification logs for thread page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Modification\Log
 *
 * @method	ViewablePostModificationLog		current()
 * @method	ViewablePostModificationLog[]		getObjects()
 * @method	ViewablePostModificationLog|null	search($objectID)
 * @property	ViewablePostModificationLog[]		$objects
 */
class ThreadModificationLogList extends ModificationLogList {
	/**
	 * @inheritDoc
	 */
	public $decoratorClassName = ViewablePostModificationLog::class;
	
	/**
	 * Initializes the board modification log list.
	 * 
	 * @param	integer[]	$postIDs
	 * @param	string		$action
	 */
	public function setPostData(array $postIDs, $action = '') {
		$this->getConditionBuilder()->add("objectTypeID = ?", [PostModificationLogHandler::getInstance()->getObjectType()->objectTypeID]);
		$this->getConditionBuilder()->add("objectID IN (?)", [$postIDs]);
		if (!empty($action)) $this->getConditionBuilder()->add("action = ?", [$action]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function readObjects() {
		parent::readObjects();
		
		if (!empty($this->objects)) {
			$userIDs = [];
			foreach ($this->objects as $object) {
				if ($object->userID) {
					$userIDs[] = $object->userID;
				}
			}
			
			if (!empty($userIDs)) {
				UserProfileRuntimeCache::getInstance()->cacheObjectIDs($userIDs);
			}
		}
	}
}
