<?php
namespace wbb\data\modification\log;
use wbb\system\log\modification\ThreadModificationLogHandler;
use wcf\data\modification\log\ModificationLogList;

/**
 * Represents a list of modification logs for board page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Modification\Log
 * 
 * @method	ViewableBoardThreadModificationLog		current()
 * @method	ViewableBoardThreadModificationLog[]		getObjects()
 * @method	ViewableBoardThreadModificationLog|null		search($objectID)
 * @property	ViewableBoardThreadModificationLog[]		$objects
 */
class BoardModificationLogList extends ModificationLogList {
	/**
	 * @inheritDoc
	 */
	public $decoratorClassName = ViewableBoardThreadModificationLog::class;
	
	/**
	 * Initializes the board modification log list.
	 * 
	 * @param	integer[]	$threadIDs
	 * @param	string		$action
	 */
	public function setThreadData(array $threadIDs, $action = '') {
		$this->getConditionBuilder()->add("objectTypeID = ?", [ThreadModificationLogHandler::getInstance()->getObjectType()->objectTypeID]);
		$this->getConditionBuilder()->add("objectID IN (?)", [$threadIDs]);
		if (!empty($action)) {
			$this->getConditionBuilder()->add("action = ?", [$action]);
		}
	}
}
