<?php
namespace wbb\data\board;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\user\object\watch\UserObjectWatchHandler;
use wcf\system\WCF;

/**
 * Represents a list of watched board nodes.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Board
 * @since	5.0
 */
class WatchedBoardNodeList extends DetailedBoardNodeList {
	/**
	 * ids of watched boards
	 * @var	integer[]
	 */
	protected $watchedBoardIDs = [];
	
	/**
	 * @inheritDoc
	 */
	public function __construct($parentID = null, $startDepth = 0, array $filter = []) {
		parent::__construct($parentID, $startDepth, $filter);
		
		$conditionBuilder = new PreparedStatementConditionBuilder();
		$conditionBuilder->add('objectTypeID = ?', [UserObjectWatchHandler::getInstance()->getObjectTypeID('com.woltlab.wbb.board')]);
		$conditionBuilder->add('userID = ?', [WCF::getUser()->userID]);
		
		$sql = "SELECT	objectID
			FROM	wcf".WCF_N."_user_object_watch
				".$conditionBuilder;
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute($conditionBuilder->getParameters());
		$this->watchedBoardIDs = $statement->fetchAll(\PDO::FETCH_COLUMN);
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function generateNodeTree($parentID, BoardNode $parentNode = null, array $filter = []) {
		$nodes = [];
		
		// apply filter
		if (count($filter)) $this->watchedBoardIDs = array_intersect($this->watchedBoardIDs, $filter);
		
		foreach ($this->watchedBoardIDs as $boardID) {
			$board = BoardCache::getInstance()->getBoard($boardID);
			if ($this->isVisible($board)) {
				$node = new $this->nodeClassname($parentNode, $board, $parentNode !== null ? $parentNode->getDepth() + 1 : 0);
				$nodes[] = $node;
			}
		}
		
		return $nodes;
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function isVisible(Board $board) {
		// do not check for ignored boards
		return RestrictedBoardNodeList::isVisible($board);
	}
}
