<?php
namespace wbb\data\board;
use wcf\data\IObjectTreeNode;
use wcf\data\ITitledObject;
use wcf\data\TObjectTreeNode;

/**
 * Represents a board node element.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Data\Board
 */
class BoardNode implements \Countable, \RecursiveIterator, IObjectTreeNode, ITitledObject {
	use TObjectTreeNode;
	
	/**
	 * parent node
	 * @var	BoardNode
	 */
	protected $parentNode;
	
	/**
	 * board object
	 * @var	Board
	 */
	protected $board;
	
	/**
	 * node depth
	 * @var	integer
	 */
	protected $depth = 0;
	
	/**
	 * Creates a new BoardNode object.
	 * 
	 * @param	BoardNode	$parentNode
	 * @param	Board		$board
	 * @param	integer		$depth
	 */
	public function __construct($parentNode = null, Board $board = null, $depth = 0) {
		$this->parentNode = $parentNode;
		$this->board = $board;
		$this->depth = $depth;
	}

	/**
	 * Sets the children of this node.
	 * 
	 * @param	BoardNode[]		$children
	 */
	public function setChildren(array $children) {
		$this->children = $children;
	}
	
	/**
	 * Returns the board object of this node
	 * 
	 * @return	Board
	 */
	public function getBoard() {
		return $this->board;
	}
	
	/**
	 * Returns node depth.
	 * 
	 * @return	integer
	 */
	public function getDepth() {
		return $this->depth;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getObjectID() {
		return $this->board ? $this->board->boardID : null;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return $this->board ? $this->board->getTitle() : '';
	}
}
