<?php
namespace wbb\action;
use wcf\action\AbstractAction;
use wcf\system\exception\IllegalLinkException;
use wcf\system\request\LinkHandler;
use wcf\util\HeaderUtil;

/**
 * Provides special search options.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Action
 * @deprecated
 */
class BoardQuickSearchAction extends AbstractAction {
	/**
	 * available search modes
	 * @var	string[]
	 */
	public static $validModes = ['unreadPosts', 'undoneThreads'];
	
	/**
	 * search mode
	 * @var	string
	 */
	public $mode = '';
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_REQUEST['mode'])) $this->mode = $_REQUEST['mode'];
		if (!in_array($this->mode, static::$validModes)) {
			throw new IllegalLinkException();
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		parent::execute();
		
		switch ($this->mode) {
			case 'unreadPosts':
				HeaderUtil::redirect(LinkHandler::getInstance()->getLink('UnreadThreadList', [
					'application' => 'wbb'
				]));
				exit;
			break;
			
			case 'undoneThreads':
				HeaderUtil::redirect(LinkHandler::getInstance()->getLink('UnresolvedThreadList', [
					'application' => 'wbb'
				]));
				exit;
			break;
		}
		
	}
}
