<?php
namespace wbb\acp\page;
use wbb\data\thread\form\ThreadFormList;
use wcf\page\SortablePage;

/**
 * Shows the thread form list.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2020 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\Acp\Page
 * @since       5.3
 */
class ThreadFormListPage extends SortablePage {
	/**
	 * @inheritDoc
	 */
	public $activeMenuItem = 'wbb.acp.menu.link.threadForm.list';
	
	/**
	 * @inheritDoc
	 */
	public $neededPermissions = ['admin.board.canEditBoard'];
	
	/**
	 * @inheritDoc
	 */
	public $objectListClassName = ThreadFormList::class;
	
	/**
	 * @inheritDoc
	 */
	public $validSortFields = ['formID', 'title'];
}
