<?php
use wbb\data\board\BoardAction;
use wbb\data\board\BoardList;
use wbb\data\thread\form\option\ThreadFormOptionAction;
use wbb\data\thread\form\option\ThreadFormOptionList;
use wbb\data\thread\form\ThreadFormAction;
use wcf\system\WCF;

/**
 * @author      Joshua Ruesweg
 * @copyright   2001-2020 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 */
$columns = WCF::getDB()->getEditor()->getColumns('wbb' . WCF_N . '_thread_form_option');
$hasBoardIDColumn = false;
foreach ($columns as $column) {
	if ($column['name'] === 'boardID') {
		$hasBoardIDColumn = true;
	}
}

if ($hasBoardIDColumn) {
	$threadFormOptionList = new ThreadFormOptionList();
	$threadFormOptionList->getConditionBuilder()->add('formID IS NULL');
	$threadFormOptionList->getConditionBuilder()->add('boardID IS NOT NULL');
	$threadFormOptionList->readObjects();
	
	$optionsByBoardID = [];
	foreach ($threadFormOptionList as $option) {
		if (!isset($optionsByBoardID[$option->boardID])) $optionsByBoardID[$option->boardID] = [];
		
		$optionsByBoardID[$option->boardID][] = $option;
	}
	if (!empty($optionsByBoardID)) {
		$boardList = new BoardList();
		$boardList->setObjectIDs(array_keys($optionsByBoardID));
		$boardList->readObjects();
	}
	
	foreach ($optionsByBoardID as $boardID => $options) {
		$formID = (new ThreadFormAction([], 'create', [
			'data' => [
				'title' => $boardList->search($boardID)->getTitle(),
			],
		]))->executeAction()['returnValues']->formID;
		
		(new ThreadFormOptionAction($options, 'update', [
			'data' => [
				'formID' => $formID,
			],
		]))->executeAction();
		
		(new BoardAction([$boardID], 'update', [
			'data' => [
				'formID' => $formID
			],
		]))->executeAction();
	}
}
