<?php
use wcf\data\package\PackageCache;
use wcf\system\WCF;

$templates = [
	'bestAnswerPost',
];

$sql = "SELECT  packageID
	FROM    wcf" . WCF_N . "_template
	WHERE   templateName = ?
		AND application = ?";
$searchStatement = WCF::getDB()->prepareStatement($sql);

$sql = "DELETE FROM     wcf" . WCF_N . "_template
	WHERE           packageID = ?
	                AND templateName = ?
	                AND application = ?";
$deletionStatement = WCF::getDB()->prepareStatement($sql);

$packageID = $this->installation->getPackageID();

foreach ($templates as $template) {
	$searchStatement->execute([$template, "wbb"]);
	$filePackageID = $searchStatement->fetchSingleColumn();
	if ($filePackageID !== null && $filePackageID != $packageID) {
		throw new \UnexpectedValueException("File '{$template}' does not belong to package '{$this->installation->getPackage()->package}' but to package '" . PackageCache::getInstance()->getPackage($filePackageID)->package . "'.");
	}
	
	$filename = WBB_DIR . "templates/{$template}.tpl";
	if (file_exists($filename)) {
		unlink($filename);
	}
	
	$deletionStatement->execute([
		$packageID,
		$template,
		"wbb",
	]);
}
