<?php
namespace wcf\acp;
use wcf\system\database\table\DatabaseTableChangeProcessor;
use wcf\system\database\table\index\DatabaseTableForeignKey;
use wcf\system\database\table\PartialDatabaseTable;
use wcf\system\package\plugin\ScriptPackageInstallationPlugin;
use wcf\system\WCF;

/**
 * @author      Tim Duesterhus
 * @copyright   2001-2020 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 */

$tables = [
	PartialDatabaseTable::create('wbb1_board')
		->foreignKeys([
			DatabaseTableForeignKey::create()
				->columns(['formID'])
				->referencedTable('wbb1_thread_form')
				->referencedColumns(['formID'])
				->onDelete('SET NULL'),
		]),
];

(new DatabaseTableChangeProcessor(
/** @var ScriptPackageInstallationPlugin $this */
	$this->installation->getPackage(),
	$tables,
	WCF::getDB()->getEditor())
)->process();
