<?php
namespace wcf\acp;
use wcf\system\database\table\column\IntDatabaseTableColumn;
use wcf\system\database\table\column\NotNullInt10DatabaseTableColumn;
use wcf\system\database\table\column\ObjectIdDatabaseTableColumn;
use wcf\system\database\table\column\VarcharDatabaseTableColumn;
use wcf\system\database\table\DatabaseTable;
use wcf\system\database\table\DatabaseTableChangeProcessor;
use wcf\system\database\table\index\DatabaseTableForeignKey;
use wcf\system\database\table\PartialDatabaseTable;
use wcf\system\package\plugin\ScriptPackageInstallationPlugin;
use wcf\system\WCF;

/**
 * @author      Alexander Ebert
 * @copyright   2001-2020 WoltLab GmbH
 * @license     WoltLab License <http://www.woltlab.com/license-agreement.html>
 */

/*
 * Do not remove the `wbb1_thread_form_option.boardID` here, it is required for another script.
 */
$tables = [
	PartialDatabaseTable::create('wcf1_user')
		->columns([
			NotNullInt10DatabaseTableColumn::create('wbbBestAnswers')
				->defaultValue(0),
		]),
	DatabaseTable::create('wbb1_thread_form')
		->columns([
			ObjectIdDatabaseTableColumn::create('formID'),
			VarcharDatabaseTableColumn::create('title')
				->length(255)
				->defaultValue('')
				->notNull(),
		]),
	PartialDatabaseTable::create('wbb1_board')
		->columns([
			IntDatabaseTableColumn::create('formID')
		])
		->foreignKeys([
			DatabaseTableForeignKey::create()
				->columns(['formID'])
				->referencedTable('wbb1_thread_form')
				->referencedColumns(['formID'])
				->onDelete('SET NULL'),
		]),
	PartialDatabaseTable::create('wbb1_thread_form_option')
		->columns([
			IntDatabaseTableColumn::create('formID'),
		])
		->foreignKeys([
			DatabaseTableForeignKey::create()
				->columns(['formID'])
				->referencedTable('wbb1_thread_form')
				->referencedColumns(['formID'])
				->onDelete('CASCADE'),
		]),
];

(new DatabaseTableChangeProcessor(
/** @var ScriptPackageInstallationPlugin $this */
	$this->installation->getPackage(),
	$tables,
	WCF::getDB()->getEditor())
)->process();
