DROP TABLE IF EXISTS wcf1_user_group_application;
CREATE TABLE wcf1_user_group_application (
	applicationID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	applicant INT(10) NOT NULL,
	username VARCHAR(255) NOT NULL DEFAULT '',
	groupID INT(10) NOT NULL,
	time INT(10) NOT NULL DEFAULT 0,
	reason TEXT NOT NULL,
	reply TEXT DEFAULT NULL,
	status TINYINT(1) NOT NULL DEFAULT 0,
	comments SMALLINT(5) NOT NULL DEFAULT 0,
	lastChangeTime INT(10) NOT NULL DEFAULT 0,
	
	UNIQUE KEY applicant (applicant, groupID),
	KEY groupID (groupID)
);

DROP TABLE IF EXISTS wcf1_user_group_leader;
CREATE TABLE wcf1_user_group_leader (
	groupID INT(10) NOT NULL,
	leaderID INT(10) NOT NULL,
	UNIQUE KEY groupID (groupID, leaderID),
	KEY leaderID (leaderID)
);


ALTER TABLE wcf1_user_group_application ADD FOREIGN KEY (groupID) REFERENCES wcf1_user_group (groupID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_group_application ADD FOREIGN KEY (applicant) REFERENCES wcf1_user (userID) ON DELETE CASCADE;

ALTER TABLE wcf1_user_group_leader ADD FOREIGN KEY (groupID) REFERENCES wcf1_user_group (groupID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_group_leader ADD FOREIGN KEY (leaderID) REFERENCES wcf1_user (userID) ON DELETE CASCADE;
