{include file='header' pageTitle='wbb.acp.menu.link.threadForm.'|concat:$action}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.menu.link.threadForm.{$action}{/lang}</h1>
		{if $action == 'edit'}<p class="contentHeaderDescription">{$threadForm->getTitle()}</p>{/if}
	</div>

	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='ThreadFormList'}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wbb.acp.menu.link.threadForm.list{/lang}</span></a></li>

			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{include file='formNotice'}

<form id="formContainer" method="post" action="{if $action == 'add'}{link application='wbb' controller='ThreadFormAdd'}{/link}{else}{link application='wbb' controller='ThreadFormEdit' id=$threadForm->formID}{/link}{/if}">
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.global.form.data{/lang}</h2>

		<dl{if $errorField == 'title'} class="formError"{/if}>
			<dt><label for="title">{lang}wcf.global.title{/lang}</label></dt>
			<dd>
				<input id="title" name="title" type="text" value="{$i18nPlainValues[title]}" class="long">
				{if $errorField == 'title'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{elseif $errorType == 'multilingual'}
							{lang}wcf.global.form.error.multilingual{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		{include file='multipleLanguageInputJavascript' elementIdentifier='title' forceSelection=false}
		
		{hascontent}
			<dl{if $errorField == 'boardIDs'} class="formError"{/if}>
				<dt><label for="boardIDs">{lang}wbb.acp.board.threadForm.boards{/lang}</label></dt>
				<dd>
					<ul class="scrollableCheckboxList" id="boardIDsContainer">
						{content}
							{foreach from=$boardList item=board}
								<li{if $board->getDepth() > 1} style="padding-left: {$board->getDepth()*20-20}px"{/if}>
									{if !$board->getBoard()->isBoard() || ($board->getBoard()->formID && !($action == 'edit' && $board->getBoard()->formID == $threadForm->formID))}
										{assign var="boardIsDisabled" value=true}
									{else}
										{assign var="boardIsDisabled" value=false}
									{/if}
									<label>
										<input type="checkbox" name="boardIDs[]" value="{@$board->getBoard()->boardID}"{if $board->getBoard()->boardID|in_array:$boardIDs} checked{/if}{if $boardIsDisabled} disabled{/if}>
										{$board->getBoard()->getTitle()}
										{if $boardIsDisabled} 
											<span 
												class="icon fa-exclamation-triangle orange jsTooltip" 
												title="{lang}wbb.acp.board.threadForm.boards.{if $board->getBoard()->isBoard()}hasAlreadyFormWarning{else}noBoard{/if}{/lang}"
											></span>
										{/if}
									</label>
								</li>
							{/foreach}
						{/content}
					</ul>
					{if $errorField == 'boardIDs'}
						<small class="innerError">
							{if $errorType == 'noValidSelection'}
								{lang}wcf.global.form.error.noValidSelection{/lang}
							{else}
								{lang}wbb.acp.board.threadForm.boards.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.acp.board.threadForm.boards.description{/lang}</small>
				</dd>
			</dl>
		{/hascontent}
		
		{event name='dataFields'}
	</section>

	<section id="threadForm" class="section">
		<h2 class="sectionTitle">
			{lang}wbb.acp.board.threadForm.options{/lang}
			<a id="addThreadFormOptionButton" href="#" class="button small"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.board.threadForm.option.add{/lang}</span></a>
		</h2>

		<div id="threadFormOptions" class="sortableListContainer"{if $threadFormOptions|empty} style="display:none;"{/if}>
			<ol id="threadFormOptionsList" class="sortableList">
				{foreach from=$threadFormOptions item=threadFormOption}
					<li class="sortableNode sortableNoNesting threadFormOption" data-object-id="{$threadFormOption->optionID}">
						<span class="sortableNodeLabel">
							<span>{$threadFormOption->getTitle()}</span>

							<span class="statusDisplay sortableButtonContainer">
								<span class="icon icon16 fa-pencil pointer jsEditButton jsTooltip" title="{lang}wcf.global.button.edit{/lang}" data-object-id="{$threadFormOption->optionID}"></span>
								<span class="icon icon16 fa-times pointer jsDeleteButton jsTooltip" title="{lang}wcf.global.button.delete{/lang}" data-object-id="{$threadFormOption->optionID}" data-confirm-message-html="{lang __encode=true}wbb.acp.board.threadForm.option.delete.confirmMessage{/lang}"></span>

								{event name='itemButtons'}
							</span>
						</span>
					</li>
				{/foreach}
			</ol>
		</div>

		<p class="threadFormNoOptionsInfo info" id="threadFormNoOptionsInfo"{if !$threadFormOptions|empty} style="display:none;"{/if}>{lang}wcf.global.noItems{/lang}</p>
		
		{if $errorField == 'threadFormFields'}
			<small class="innerError">
				{if $errorType == 'empty'}
					{lang}wcf.global.form.error.empty{/lang}
				{else}
					{lang}wbb.acp.board.threadForm.threadFormFields.error.{@$errorType}{/lang}
				{/if}
			</small>
		{/if}
	</section>

	<input type="hidden" name="threadFormTmpHash" value="{$threadFormTmpHash}">

	<script data-relocate="true">
		require(['WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/DialogHandler', 'WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Add', 'WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit', 'WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Sortable', 'Language', 'WoltLabSuite/Core/Ui/ItemList/Filter'], function (DialogHandler, ThreadFormOptionAdd, ThreadFormOptionEdit, ThreadFormOptionSortable, Language, UiItemListFilter) {
			DialogHandler.setI18n({$availableLanguages|count} > 1);

			ThreadFormOptionAdd.init('{$threadFormTmpHash}', {if $threadForm|isset}{$threadForm->formID}{else}null{/if});
			ThreadFormOptionEdit.init();
			ThreadFormOptionSortable.init();

			Language.addObject({
				'wbb.acp.board.threadForm.option.add': '{jslang}wbb.acp.board.threadForm.option.add{/jslang}',
				'wbb.acp.board.threadForm.option.edit': '{jslang}wbb.acp.board.threadForm.option.edit{/jslang}',
				'wcf.global.filter.button.visibility': '{jslang}wcf.global.filter.button.visibility{/jslang}',
				'wcf.global.filter.button.clear': '{jslang}wcf.global.filter.button.clear{/jslang}',
				'wcf.global.filter.error.noMatches': '{jslang}wcf.global.filter.error.noMatches{/jslang}',
				'wcf.global.filter.placeholder': '{jslang}wcf.global.filter.placeholder{/jslang}',
				'wcf.global.filter.visibility.activeOnly': '{jslang}wcf.global.filter.visibility.activeOnly{/jslang}',
				'wcf.global.filter.visibility.highlightActive': '{jslang}wcf.global.filter.visibility.highlightActive{/jslang}',
				'wcf.global.filter.visibility.showAll': '{jslang}wcf.global.filter.visibility.showAll{/jslang}',
			});
			
			new UiItemListFilter('boardIDsContainer');
		});

		$(function () {
			new WCF.Action.Delete('wbb\\data\\thread\\form\\option\\ThreadFormOptionAction', '#threadFormOptions .threadFormOption');
		});
	</script>

	{event name='sections'}

	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

{include file='footer'}
