{include file='header' pageTitle='wbb.acp.rssFeed.list'}

<script data-relocate="true">
	$(function() {
		new WCF.Action.Delete('wbb\\data\\rss\\feed\\RssFeedAction', '.jsRssFeedRow');
		new WCF.Action.Toggle('wbb\\data\\rss\\feed\\RssFeedAction', '.jsRssFeedRow');
		
		var options = { };
		{if $pages > 1}
			options.refreshPage = true;
			{if $pages == $pageNo}
				options.updatePageNumber = -1;
			{/if}
		{else}
			options.emptyMessage = '{lang}wcf.global.noItems{/lang}';
		{/if}
		
		new WCF.Table.EmptyTableHandler($('#rssFeedTableContainer'), 'jsRssFeedRow', options);
	});
</script>

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.rssFeed.list{/lang}</h1>
		<p class="contentHeaderDescription">{lang}wbb.acp.rssFeed.description{/lang}</p>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link application='wbb' controller='RssFeedAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.rssFeed.add{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{hascontent}
	<div class="paginationTop">
		{content}{pages print=true assign=pagesLinks application="wbb" controller="RssFeedList" link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}{/content}
	</div>
{/hascontent}

{if $objects|count}
	<div id="rssFeedTableContainer" class="section tabularBox">
		<table class="table">
			<thead>
				<tr>
					<th class="columnID columnFeedID{if $sortField == 'feedID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=feedID&sortOrder={if $sortField == 'feedID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.objectID{/lang}</a></th>
					<th class="columnTitle{if $sortField == 'title'} active {@$sortOrder}{/if}"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=title&sortOrder={if $sortField == 'title' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.title{/lang}</a></th>
					<th class="columnDate columnLastRun{if $sortField == 'lastRun'} active {@$sortOrder}{/if}"><a href="{link application='wbb' controller='RssFeedList'}pageNo={@$pageNo}&sortField=lastRun&sortOrder={if $sortField == 'lastRun' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wbb.acp.rssFeed.lastRun{/lang}</a></th>
					
					{event name='columnHeads'}
				</tr>
			</thead>
			
			<tbody>
				{foreach from=$objects item=feed}
					<tr class="jsRssFeedRow">
						<td class="columnIcon">
							<span class="icon icon16 fa-{if !$feed->isDisabled}check-{/if}square-o jsToggleButton jsTooltip pointer" title="{lang}wcf.global.button.{if $feed->isDisabled}enable{else}disable{/if}{/lang}" data-object-id="{@$feed->feedID}"></span>
							<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}" title="{lang}wcf.global.button.edit{/lang}" class="jsTooltip"><span class="icon icon16 fa-pencil"></span></a>
							<span class="icon icon16 fa-times jsDeleteButton jsTooltip pointer" title="{lang}wcf.global.button.delete{/lang}" data-object-id="{@$feed->feedID}" data-confirm-message-html="{lang __encode=true}wbb.acp.rssFeed.delete.sure{/lang}"></span>
							
							{event name='rowButtons'}
						</td>
						<td class="columnID">{@$feed->feedID}</td>
						<td class="columnTitle">
							<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}">{$feed->title}</a>
							<p><small>{$feed->url}</small></p>
						</td>
						<td class="columnDate columnLastRun">
							{if $feed->errorMessage}<a href="{link application='wbb' controller='RssFeedEdit' id=$feed->feedID}{/link}"><span class="icon icon16 fa-exclamation-triangle jsTooltip" title="{lang}wbb.acp.rssFeed.errorMessage{/lang}"></span></a>{/if}
							{if $feed->lastRun}{@$feed->lastRun|time}{/if}
						</td>
						
						{event name='columns'}
					</tr>
				{/foreach}
			</tbody>
		</table>
	</div>
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}
		
		<nav class="contentFooterNavigation">
			<ul>
				<li><a href="{link application='wbb' controller='RssFeedAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.rssFeed.add{/lang}</span></a></li>
				
				{event name='contentFooterNavigation'}
			</ul>
		</nav>
	</footer>
{else}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/if}

{include file='footer'}
