{include file='header' pageTitle='wbb.acp.board.permission.edit'}

<script data-relocate="true">
	$(function() {
		WCF.Language.addObject({
			'wbb.acp.board.permission.unsavedChanges': '{jslang}wbb.acp.board.permission.unsavedChanges{/jslang}'
		});
		
		var $values = {
			{implode from=$values key=aclOptionID item=objectValues}{@$aclOptionID}: { {implode from=$objectValues key=boardID item=optionValue}{@$boardID}: {@$optionValue}{/implode} }{/implode}
		};
		var $groupValues = {
			{implode from=$aclGroupOptionValues key=aclOptionID item=objectValues}{@$aclOptionID}: { {implode from=$objectValues key=boardID item=optionValue}{@$boardID}: {@$optionValue}{/implode} }{/implode}
		};
		var $userGroupOptionValues = {
			{implode from=$userGroupOptionValues key=aclOptionID item=value}{@$aclOptionID}: {@$value}{/implode}
		};
		
		new WBB.ACP.Board.Permission.User({@$userID}, $values, $groupValues, $userGroupOptionValues);
	});
</script>

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.board.permission.edit{/lang}</h1>
		<p class="contentHeaderDescription">{lang}wbb.acp.board.permission.edit.description{/lang}</p>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			<li><a href="{link controller='UserSearch'}{/link}" class="button"><span class="icon icon16 fa-search"></span> <span>{lang}wcf.acp.user.search{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{include file='formError'}

{if $success|isset}
	<p class="success">{lang}wcf.global.success.edit{/lang}</p>
{/if}

<p class="info">{lang}wbb.acp.board.permission.user.notice{/lang}</p>

<form method="post" action="{link application='wbb' controller='BoardPermissionUser' id=$userID}{/link}">
	<section class="section">
		<h2 class="sectionTitle">{lang}wbb.acp.board.permission.user{/lang}</h2>
		
		<dl>
			<dt>
				{lang}wcf.user.username{/lang}
			</dt>
			<dd>
				{$user->username}
			</dd>
		</dl>
		<dl>
			<dt>
				<label for="aclSelection">{lang}wbb.acp.board.permission{/lang}</label>
			</dt>
			<dd>
				<select id="aclSelection">
					{foreach from=$aclCategories key=aclCategory item=categoryName}
						<optgroup label="{$categoryName}">
							{foreach from=$aclOptions[$aclCategory] key=aclOptionID item=aclOption}
								<option value="{@$aclOptionID}">{$aclOption}</option>
							{/foreach}
						</optgroup>
					{/foreach}
				</select>
			</dd>
		</dl>
	</section>
	
	<section class="section" id="aclContainer">
		<h2 class="sectionTitle">{lang}wbb.acp.board.list{/lang}</h2>
		
		<ol class="sortableList">
			{foreach from=$boardList item=boardNode}
				{if !$boardNode->getBoard()->isExternalLink()}
					<li id="boardNode{@$boardNode->getBoard()->boardID}" data-object-id="{@$boardNode->getBoard()->boardID}">
						<span class="sortableNodeLabel sortableNodeStaticItem">
							<span class="icon icon16 fa-check-circle green"></span>
							
							{$boardNode->getTitle()}
							
							<span class="statusDisplay">
								<label class="jsTooltip" title="{lang}wcf.acl.option.grant{/lang}"><input type="checkbox" id="grant{@$boardNode->getBoard()->boardID}"></label>
								<label class="jsTooltip" title="{lang}wcf.acl.option.deny{/lang}"><input type="checkbox" id="deny{@$boardNode->getBoard()->boardID}"></label>
							</span>
						</span>
					
					<ol class="sortableList">{if !$boardNode->hasChildren()}</ol></li>{/if}
				{/if}
				
				{if !$boardNode->hasChildren() && $boardNode->isLastSibling()}
					{@"</ol></li>"|str_repeat:$boardNode->getOpenParentNodes()}
				{/if}
			{/foreach}
		</ol>
	</section>
	
	{event name='sections'}
	
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

{include file='footer'}
