{include file='header' pageTitle='wbb.acp.board.list'}

<script data-relocate="true">
	{if $count <= 200}
		require(['WoltLabSuite/Core/Ui/Sortable/List'], function (UiSortableList) {
			new UiSortableList({
				containerId: 'boardNodeList',
				className: 'wbb\\data\\board\\BoardAction'
			});
		});
	{/if}
	
	$(function() {
		new WBB.ACP.Board.Collapsible('wbb\\data\\board\\BoardAction');
		{if $__wcf->session->getPermission('admin.board.canDeleteBoard')}
			new WBB.ACP.Board.Delete('wbb\\data\\board\\BoardAction', '.sortableNode', '> .sortableNodeLabel .jsDeleteButton');
		{/if}
	});
</script>

{if $count > 200}
	<style>
		#boardNodeList .sortableNode,
		#boardNodeList .sortableNodeLabel {
			cursor: initial;
		}
	</style>
{/if}


<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wbb.acp.board.list{/lang}</h1>
	</div>
	
	<nav class="contentHeaderNavigation">
		<ul>
			{if $boardNodeList->hasChildren()}
				<li><a href="{link application='wbb' controller='BoardPermissionCopy'}{/link}" class="button"><span class="icon icon16 fa-key"></span> <span>{lang}wbb.acp.board.permission.copy{/lang}</span></a></li>
			{/if}
			<li><a href="{link application='wbb' controller='BoardAdd'}{/link}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.acp.board.add{/lang}</span></a></li>
			
			{event name='contentHeaderNavigation'}
		</ul>
	</nav>
</header>

{hascontent}
	<div id="boardNodeList" class="section sortableListContainer">
		<ol id="boardContainer0" class="sortableList" data-object-id="0">
			{content}
				{foreach from=$boardNodeList item=boardNode}
					<li class="sortableNode{if $boardNode->getBoard()->isCategory()} jsCollapsibleCategory{elseif $boardNode->getBoard()->isExternalLink()} sortableNoNesting{/if}" data-object-id="{@$boardNode->getBoard()->boardID}" data-is-open="{if $boardNode->getBoard()->boardID|in_array:$collapsedCategoryIDs}0{else}1{/if}">
						<span class="sortableNodeLabel">
							{if !$boardNode->getBoard()->isCategory()}
								{if $boardNode->getBoard()->isBoard()}
									<span class="icon icon16 fa-{$boardNode->getBoard()->getIconName('default')}"{if $boardNode->getBoard()->getIconColor('default')} style="color: {$boardNode->getBoard()->getIconColor('default')}"{/if}></span>
								{elseif $boardNode->getBoard()->isExternalLink()}
									<span class="icon icon16 fa-{$boardNode->getBoard()->getIconName('external')}"{if $boardNode->getBoard()->getIconColor('external')} style="color: {$boardNode->getBoard()->getIconColor('external')}"{/if}></span>
								{/if}
							{/if}
							<a href="{link application='wbb' controller='BoardEdit' id=$boardNode->getBoard()->boardID}{/link}">{$boardNode->getTitle()}</a>
							
							<span class="statusDisplay sortableButtonContainer">
								<span class="icon icon16 fa-arrows sortableNodeHandle"></span>
								{if $__wcf->session->getPermission('admin.board.canEditBoard')}
									<a href="{link application='wbb' controller='BoardEdit' id=$boardNode->getBoard()->boardID}{/link}" class="jsTooltip" title="{lang}wcf.global.button.edit{/lang}"><span class="icon icon16 fa-pencil"></span></a>
								{/if}
								{if !$boardNode->getBoard()->isExternalLink() && $__wcf->session->getPermission('admin.board.canAddBoard')}
									<a href="{link application='wbb' controller='BoardAdd'}parentID={@$boardNode->getBoard()->boardID}{/link}" class="jsTooltip" title="{lang}wbb.acp.board.addSubboard{/lang}"><span class="icon icon16 fa-plus"></span></a>
								{/if}
								{if $__wcf->session->getPermission('admin.board.canDeleteBoard')}
									{if $boardNode->getBoard()->posts <= 5000}
										<span class="icon icon16 fa-times pointer jsDeleteButton jsTooltip" title="{lang}wcf.global.button.delete{/lang}" data-object-id="{@$boardNode->getBoard()->boardID}" data-confirm-message-html="{lang __encode=true}wbb.acp.board.delete.sure{/lang}"></span>
									{else}
										<span class="icon icon16 fa-times disabled" title="{lang}wcf.global.button.delete{/lang}"></span>
									{/if}
								{/if}
								{event name='itemButtons'}
							</span>
						</span>
					
					<ol id="boardContainer{@$boardNode->getBoard()->boardID}" class="sortableList" data-object-id="{@$boardNode->getBoard()->boardID}">{if !$boardNode->hasChildren()}</ol></li>{/if}
					
					{if !$boardNode->hasChildren() && $boardNode->isLastSibling()}
						{@"</ol></li>"|str_repeat:$boardNode->getOpenParentNodes()}
					{/if}
				{/foreach}
			{/content}
		</ol>
	</div>
	
	<div class="formSubmit">
		<button class="button buttonPrimary" data-type="submit">{lang}wcf.global.button.saveSorting{/lang}</button>
	</div>
{hascontentelse}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/hascontent}

{include file='footer'}
