define(['EventHandler', 'Language', 'WoltLabSuite/Core/Date/Picker'], function(EventHandler, Language, DatePicker) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			_toggleEnableTime: function() {},
			_handleError: function() {},
			_reset: function() {}
		};
		return Fake;
	}
	
	var _messageQuickReply = elById('messageQuickReply');
	var _disablePost = elById('threadReplyDisablePost');
	
	return {
		init: function () {
			_disablePost.addEventListener(WCF_CLICK_EVENT, this._toggleEnableTime.bind(this));
			
			EventHandler.add('com.woltlab.wcf.redactor2', 'handleError_text', this._handleError.bind(this));
			EventHandler.add('com.woltlab.wcf.redactor2', 'reset_text', this._reset.bind(this));
		},
		
		_toggleEnableTime: function() {
			elBySelAll('.jsThreadQuickReplyEnableTime', _messageQuickReply, function(element) {
				window[(_disablePost.checked ? 'elShow' : 'elHide')](element);
			});
		},
		
		_handleError: function(data) {
			if (data.returnValues.fieldName === 'enableTime') {
				var datePickerElement = elById('threadReplyPostEnableTimeDatePicker');
				
				data.api.throwError(
					datePickerElement.nextElementSibling,
					Language.get('wbb.post.enableTime.error.' + data.returnValues.errorType)
				);
				
				var tabMenu = datePickerElement.closest('.messageTabMenu');
				window.jQuery(tabMenu).messageTabMenu('showTab', 'settings', true);
				
				data.cancel = true;
			}
		},
		
		_reset: function () {
			DatePicker.clear('threadReplyPostEnableTime');
			_disablePost.checked = false;
			this._toggleEnableTime();
		}
	};
});
