/**
 * Hides modification log entries.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Ui/Thread/Modification/Log/Hide
 */
define(['Ajax', 'Dom/ChangeListener', 'Ui/Confirmation', 'Language', 'Ui/Notification'], function(Ajax, DomChangeListener, Confirmation, Language, UiNotification) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			_click: function() {},
			execute: function() {},
			_ajaxSuccess: function() {},
			_ajaxSetup: function() {}
		};
		return Fake;
	}
	
	return {
		/**
		 * Initializes the button.
		 */
		init: function() {
			var callback = this._click.bind(this);
			elBySelAll('.jsModificationLogEntryHideButton', null, function(entry) {
				entry.addEventListener(WCF_CLICK_EVENT, callback);
			});
		},
		
		/**
		 * Handles clicks on hide button.
		 *
		 * @param       {Event}         event           event object
		 * @protected
		 */
		_click: function(event) {
			if (elData(event.currentTarget, 'is-summarized') === "1") {
				var logIDs = elData(event.currentTarget, 'log-ids');
				Confirmation.show({
					confirm: this.execute.bind(this, JSON.parse(logIDs)),
					message: Language.get('wbb.thread.modification.log.thread.hide.confirmMessage')
				});
			}
			else {
				var logID = elData(event.currentTarget, 'log-id');
				Confirmation.show({
					confirm: this.execute.bind(this, [logID]),
					message: Language.get('wbb.thread.modification.log.thread.hide.confirmMessage')
				});
			}
		},
		
		/**
		 * Hides the button
		 *
		 * @param       {int[]}         logIDs         list of log ids
		 */
		execute: function (logIDs) {
			Ajax.api(this, {
				objectIDs: logIDs
			});
		},
		
		_ajaxSuccess: function(data) {
			data.returnValues.logIDs.forEach(function (logID) {
				if (elBySel('.modificationLogEntry[data-log-id="'+ logID +'"]')) {
					elBySel('.modificationLogEntry[data-log-id="'+ logID +'"]').remove();
				}
			});
			
			// assign lastModificationLogEntry
			elBySelAll('.modificationLogEntry', elBySel('.wbbThreadPostList'), function (element) {
				if (!element.nextElementSibling.classList.contains('modificationLogEntry') && !element.classList.contains('lastModificationLogEntry')) {
					element.classList.add('lastModificationLogEntry');
				}
			});
			
			DomChangeListener.trigger();
			
			UiNotification.show('wcf.global.success');
		},
		
		_ajaxSetup: function() {
			return {
				data: {
					actionName: 'hide',
					className: 'wbb\\data\\modification\\log\\ThreadModificationLogAction'
				}
			};
		}
	};
});
