define(['Ajax', 'Language', 'Ui/Dialog', 'WoltLabSuite/Core/Date/Picker'], function (Ajax, Language, UiDialog, DatePicker) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			_submit: function() {},
			_ajaxSuccess: function() {},
			_ajaxSetup: function() {},
			_dialogSetup: function() {}
		};
		return Fake;
	}
	
	var _callback = null;
	var _objectId = 0;
	
	return {
		init: function (objectId, callback) {
			_objectId = objectId;
			_callback = callback;
			
			Ajax.api(this);
		},
		
		_submit: function (event) {
			event.preventDefault();
			
			if (elById('threadEnable_enableNow').checked) {
				_callback(true, elById('threadEnable_enableNowAndUpdateTime').checked);
				
				UiDialog.close(this);
			}
			else {
				Ajax.api(this, {
					actionName: 'setEnableTime',
					parameters: {
						enableTime: DatePicker.getValue('threadEnable_enableTime')
					}
				});
			}
		},
		
		_ajaxSuccess: function (data) {
			if (data.actionName === 'prepareEnable') {
				UiDialog.open(this, data.returnValues.template);
			}
			else {
				_callback(false);
				
				UiDialog.close(this);
			}
		},
		
		_ajaxSetup: function () {
			return {
				data: {
					actionName: 'prepareEnable',
					className: 'wbb\\data\\thread\\ThreadAction',
					objectIDs: [_objectId]
				}
			};
		},
		
		_dialogSetup: function () {
			return {
				id: 'wbbThreadEnable',
				options: {
					onClose: function () {
						DatePicker.destroy('threadEnable_enableTime');
					},
					onShow: (function (content) {
						var enableNowAndUpdateTime = elById('threadEnable_enableNowAndUpdateTime');
						elById('threadEnable_enableNow').addEventListener('change', function () {
							elToggle(elById('threadEnable_enableTimeContainer'));
							enableNowAndUpdateTime.disabled = !enableNowAndUpdateTime.disabled;
						});
						
						elBySel('.formSubmit > button', content).addEventListener(WCF_CLICK_EVENT, this._submit.bind(this));
					}).bind(this),
					title: Language.get('wbb.thread.edit.enable')
				},
				source: null
			};
		}
	}
});
