/**
 * Enables the button to mark/unmark best answers. 
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Ui/Thread/BestAnswer
 * @since       5.2
 */
define(['Ajax', 'Language', 'Ui/Confirmation', 'List', 'Dom/ChangeListener'], function (Ajax, Language, UiConfirmation, Dictionary, DomChangeListener) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			_initButtons: function() {},
			_markBestAnswer: function() {},
			_ajaxSuccess: function() {},
			_ajaxSetup: function() {},
		};
		return Fake;
	}
	
	return {
		init: function (threadID, containerSelector) {
			this._knownButtons = new Dictionary();
			this._threadID = threadID;
			
			if (containerSelector === undefined) {
				this._containerSelector = '.wbbThreadPostList';
			}
			else {
				this._containerSelector = containerSelector;
			}
			
			this._initButtons();
			
			DomChangeListener.add('WoltLabSuite/Forum/Ui/Thread/BestAnswer-' + this._threadID, this._initButtons.bind(this));
		},
		
		_initButtons: function() {
			var container = elBySel(this._containerSelector);
			var buttons = elBySelAll('.jsMarkAsBestAnswer', container);
			
			for (var i = 0, length = buttons.length; i < length; i++) {
				var element = buttons[i];
				if (this._knownButtons.has(element)) {
					continue;
				}
				
				element.addEventListener(WCF_CLICK_EVENT, this._click.bind(this, element));
				
				this._knownButtons.add(element);
			}
		},
		
		_click: function(element, event) {
			event.preventDefault();
			
			if (elData(element, 'is-best-answer') == 1) {
				this._unmarkBestAnswer(~~elData(element, 'object-id'));
			}
			else {
				UiConfirmation.show({
					confirm: this._markBestAnswer.bind(this, ~~elData(element, 'object-id')),
					message: Language.get('wbb.thread.markAsBestAnswer.confirmMessage')
				});
			}
		},
		
		_markBestAnswer: function(postID) {
			Ajax.api(this, {
				actionName: 'markAsBestAnswer',
				parameters: {
					threadID: this._threadID,
					postID: postID
				}
			});
		},
		
		_unmarkBestAnswer: function(postID) {
			Ajax.api(this, {
				actionName: 'unmarkAsBestAnswer',
				parameters: {
					threadID: this._threadID,
					postID: postID
				}
			});
		},
		
		_ajaxSuccess: function (data) {
			window.location.reload();
		},
		
		_ajaxSetup: function () {
			return {
				data: {
					className: 'wbb\\data\\thread\\ThreadAction'
				}
			};
		}
	}
});
