/**
 * Manager instance for posts.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Ui/Post/Manager
 */
define(['Core', 'Language', 'Ui/Notification', 'WoltLabSuite/Core/Ui/Message/Manager'], function(Core, Language, UiNotification, UiMessageManager) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			update: function() {},
			_updateState: function() {},
			_ajaxSuccess: function() {},
			init: function() {},
			rebuild: function() {},
			getPermission: function() {},
			getPropertyValue: function() {},
			updateItems: function() {},
			updateAllItems: function() {},
			setNote: function() {},
			_update: function() {},
			_toggleMessageStatus: function() {},
			_getAttributeName: function() {},
			_ajaxSetup: function() {}
		};
		return Fake;
	}
	
	/**
	 * @constructor
	 */
	function UiPostManager(threadId) {
		UiPostManager._super.call(this, {
			className: 'wbb\\data\\post\\PostAction',
			selector: '.wbbPost'
		});
		
		this._threadId = threadId;
	}
	Core.inherit(UiPostManager, UiMessageManager, {
		update: function(objectId, actionName, parameters) {
			if (parameters.hasOwnProperty('enableNote')) {
				this.setNote(objectId, 'wbbPostDelayedNote', parameters.enableNote);
			}
			else {
				//noinspection JSUnresolvedVariable
				UiPostManager._super.prototype.update.call(this, objectId, actionName, parameters);
			}
		},
		
		/**
		 * @see WoltLabSuite/Core/Ui/Message/Manager._updateState()
		 */
		_updateState: function(element, propertyName, propertyValue, propertyValueBoolean) {
			//noinspection JSUnresolvedVariable
			UiPostManager._super.prototype._updateState.call(this, element, propertyName, propertyValue, propertyValueBoolean);
			
			switch (propertyName) {
				case 'deleted':
					this._elements.delete(elData(element, 'object-id'));
					if (element.parentNode && element.parentNode.nodeName === 'LI') elRemove(element.parentNode);
					else elRemove(element);
					break;
				
				case 'isClosed':
					if (propertyValueBoolean) {
						var listItem = elCreate('li');
						listItem.className = 'wbbPostClosed';
						var span = elCreate('span');
						span.className = 'jsTooltip icon icon16 fa-lock';
						elAttr(span, 'title', Language.get('wbb.post.closed'));
						
						listItem.appendChild(span);
						var messageQuickOptions = elBySel('.messageQuickOptions', element);
						if (messageQuickOptions !== null) {
							messageQuickOptions.insertBefore(listItem, messageQuickOptions.firstElementChild);
						}
					}
					else {
						var icon = elBySel('.wbbPostClosed', element);
						if (icon !== null) {
							elRemove(icon);
						}
					}
					break;
				
				case 'isDeleted':
					if (!propertyValueBoolean) {
						var deleteNote = elBySel('.wbbPostDeleteNote', element);
						if (deleteNote !== null) elRemove(deleteNote);
					}
					break;
			}
		},
		
		_ajaxSuccess: function(data) {
			var post;
			//noinspection JSUnresolvedVariable
			for (var postId in data.returnValues.postData) {
				//noinspection JSUnresolvedVariable
				if (data.returnValues.postData.hasOwnProperty(postId)) {
					post = this._elements.get(postId);
					if (post === undefined) {
						continue;
					}
					
					//noinspection JSUnresolvedVariable
					this.updateItems([postId], data.returnValues.postData[postId]);
				}
			}
			
			//noinspection JSUnresolvedVariable
			if (data.returnValues.threadData !== undefined && data.returnValues.threadData.hasOwnProperty(this._threadId)) {
				//noinspection JSUnresolvedVariable
				var threadData = data.returnValues.threadData[this._threadId];
				if (threadData.deleted) {
					UiNotification.show(undefined, function() {
						window.location = threadData.deleted;
					});
				}
			}
		}
	});
	
	return UiPostManager;
});
