define(['WoltLabSuite/Forum/Ui/Post/InlineEditor', 'WoltLabSuite/Forum/Ui/Post/Manager', 'WoltLabSuite/Core/Controller/Clipboard'], function(UiPostInlineEditor, UiPostManager, ControllerClipboard) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {}
		};
		return Fake;
	}
	
	return {
		init: function() {
			// mixed lists do not offer editing capabilities
			var inlineEdit = new UiPostInlineEditor(0, { disableEdit: true });
			var postManager = new UiPostManager();
			inlineEdit.setPostManager(postManager);
			
			// we're pretending to be on the thread page and that there are marked items
			ControllerClipboard.setup({
				hasMarkedItems: true,
				pageClassName: 'wbb\\page\\ThreadPage',
				pageObjectId: 0
			});
			
			new window.WBB.Post.Clipboard(postManager);
		}
	}
});
