define(['Ajax', 'Language', 'Ui/Dialog', 'WoltLabSuite/Core/Date/Picker'], function (Ajax, Language, UiDialog, DatePicker) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			_submit: function() {},
			_ajaxSuccess: function() {},
			_ajaxSetup: function() {},
			_dialogSetup: function() {}
		};
		return Fake;
	}
	
	var _callback = null;
	var _objectId = 0;
	
	return {
		init: function (objectId, callback) {
			_objectId = objectId;
			_callback = callback;
			
			Ajax.api(this, {
				objectIDs: [_objectId]
			});
		},
		
		_submit: function (event) {
			event.preventDefault();
			
			if (elById('postEnable_enableNow').checked) {
				_callback({
					updateTime: elById('postEnable_enableNowAndUpdateTime').checked
				});
				
				UiDialog.close(this);
			}
			else {
				Ajax.api(this, {
					actionName: 'setEnableTime',
					objectIDs: [_objectId],
					parameters: {
						enableTime: DatePicker.getValue('postEnable_enableTime')
					}
				});
			}
		},
		
		_ajaxSuccess: function (data) {
			if (data.actionName === 'prepareEnable') {
				UiDialog.open(this, data.returnValues.template);
			}
			else {
				_callback({
					enableNote: data.returnValues.enableNote
				});
				
				UiDialog.close(this);
			}
		},
		
		_ajaxSetup: function () {
			return {
				data: {
					actionName: 'prepareEnable',
					className: 'wbb\\data\\post\\PostAction'
				}
			};
		},
		
		_dialogSetup: function () {
			return {
				id: 'wbbPostEnable',
				options: {
					onClose: function () {
						DatePicker.destroy('postEnable_enableTime');
					},
					onShow: (function (content) {
						var enableNowAndUpdateTime = elById('postEnable_enableNowAndUpdateTime');
						elById('postEnable_enableNow').addEventListener('change', function () {
							elToggle(elById('postEnable_enableTimeContainer'));
							enableNowAndUpdateTime.disabled = !enableNowAndUpdateTime.disabled;
						});
						
						elBySel('.formSubmit > button', content).addEventListener(WCF_CLICK_EVENT, this._submit.bind(this));
					}).bind(this),
					title: Language.get('wbb.post.edit.enable')
				},
				source: null
			};
		}
	}
});
