/**
 * Mobile optimizations for forum.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Ui/Mobile
 */
define(['Ui/Screen', 'WoltLabSuite/Core/Ui/Mobile'], function(UiScreen, UiMobile) {
	"use strict";
	
	var _boards = null;
	
	/**
	 * @exports     WoltLabSuite/Forum/Ui/Mobile
	 */
	return {
		init: function() {
			var boardList = elBySel('.wbbBoardList');
			if (boardList) _boards = elByClass('wbbBoardMain', boardList);
			
			UiScreen.on('screen-sm-down', {
				match: this._enableShadow.bind(this),
				unmatch: this._disableShadow.bind(this),
				setup: this._enableShadow.bind(this)
			});
		},
		
		_enableShadow: function() {
			if (_boards) UiMobile.rebuildShadow(_boards, '.containerHeadline > h3 > a');
		},
		
		_disableShadow: function() {
			if (_boards) UiMobile.removeShadow(_boards);
		}
	};
});
