/**
 * Makes the thread form options sortable. 
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Sortable
 * @since       5.2
 */
define(['Ajax', 'Environment'],
	function (Ajax, Environment) {
		"use strict";
		
		/**
		 * @exports     WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Sortable
		 */
		return {
			init: function () {
				this._rebuild();
			},
			
			/**
			 * Add eventListeners to the thread option edit forms.
			 */
			_rebuild: function () {
				if (Environment.platform() === 'desktop') {
					new window.WCF.Sortable.List('threadFormOptions', '', 0, {
						axis: false,
						items: 'li.sortableNode',
						toleranceElement: null,
						update: (function () {
							var optionIDs = [];
							var elements = elBySelAll('li.sortableNode', elById('threadFormOptions'));
							
							Object.keys(elements).forEach(function (key) {
								optionIDs.push(elData(elements[key], 'object-id'));
							}.bind(this));
							
							if (optionIDs.length) {
								Ajax.api(this, {
									parameters: {
										optionIDs: optionIDs
									}
								});
							}
						}).bind(this)
					}, true);
				}
			},
			
			_ajaxSetup: function () {
				return {
					data: {
						className: 'wbb\\data\\thread\\form\\option\\ThreadFormOptionAction',
						actionName: 'updatePosition'
					}
				};
			}
		};
	});
