/**
 * Handles edit on thread form options. 
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit
 * @since       5.2
 */
define(['Ajax', 'EventHandler', 'Dictionary', 'Dom/ChangeListener', 'Language', 'Ui/Dialog', 'WoltLabSuite/Core/Language/Input', 'WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/DialogHandler'], 
function (Ajax, EventHandler, Dictionary, DomChangeListener, Language, UiDialog, LanguageInput, DialogHandler) {
	"use strict";
	
	var _optionID;  
	var _knownElements = new Dictionary();
	
	/**
	 * @exports     WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit
	 */
	return {
		init: function () {
			this._rebuild();
			
			DomChangeListener.add('WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Edit', this._rebuild.bind(this));
		},
		
		/**
		 * Add eventListeners to the thread option edit forms.
		 */
		_rebuild: function () {
			var elements = elBySelAll('#threadForm .jsEditButton');
			
			for (var i = 0, length = elements.length; i < length; i++) {
				var element = elements[i];
				var objectId = ~~elData(element, 'object-id');
				if (_knownElements.has(objectId)) {
					continue;
				}
				
				element.addEventListener('click', this._loadDialog.bind(this));
				
				_knownElements.set(objectId, element);
			}
		},
		
		/**
		 * Opens the edit dialog.  
		 * 
		 * @param       {Event}         event
		 */
		_loadDialog: function (event) {
			event.preventDefault();
			
			_optionID = elData(event.currentTarget, 'object-id');
			
			Ajax.api(this, {
				actionName: 'prepareEdit',
				objectIDs: [
					_optionID
				]
			});
		},
		
		/**
		 * Saves the dialog content for the option id. 
		 * 
		 * @param       {Object}        dialogData
		 */
		saveDialog: function (dialogData) {
			Ajax.api(this, {
				actionName: 'saveEdit',
				parameters: {
					data: dialogData
				},
				objectIDs: [
					_optionID
				]
			});
		},
		
		_ajaxSuccess: function (data) {
			if (data.actionName === 'saveEdit') {
				DialogHandler.closeDialog();
			}
			else if (data.actionName === 'prepareEdit') {
				DialogHandler.loadDialog(this.saveDialog.bind(this), data.returnValues, Language.get('wbb.acp.board.threadForm.option.edit'));
			}
		},
		
		_ajaxSetup: function () {
			return {
				data: {
					className: 'wbb\\data\\thread\\form\\option\\ThreadFormOptionAction'
				}
			};
		}
	};
});
