/**
 * Provides the thread form option add dialog.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Add
 * @since       5.2
 */
define(['Ajax', 'EventHandler', 'Language', 'Ui/Dialog', 'WoltLabSuite/Core/Language/Input', 'WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/DialogHandler'], 
function (Ajax, EventHandler, Language, UiDialog, LanguageInput, DialogHandler) {
	"use strict";
	
	var _tmpHash = '';
	var _formID = null;
	
	/**
	 * @exports     WoltLabSuite/Forum/Acp/Ui/Board/Thread/Form/Option/Add
	 */
	return {
		init: function (tmpHash, formID) {
			elById('addThreadFormOptionButton').addEventListener('click', this._loadDialog.bind(this));
			
			_tmpHash = tmpHash;
			_formID = formID;
		},
		
		/**
		 * Open the dialog to add a option. 
		 * 
		 * @param       {Event}         event
		 */
		_loadDialog: function (event) {
			event.preventDefault();
			
			DialogHandler.loadDialog(this.saveDialog.bind(this), null, Language.get('wbb.acp.board.threadForm.option.add'));
		},
		
		/**
		 * Adds the option for the current dialog. 
		 * 
		 * @param       {array}         dialogData
		 */
		saveDialog: function (dialogData) {
			dialogData['tmpHash'] = _tmpHash;
			dialogData['formID'] = _formID;
			
			Ajax.api(this, {
				parameters: {
					data: dialogData
				}
			});
		},
		
		/**
		 * Insert a new option to the options list. 
		 * 
		 * @param       {int}           optionID
		 * @param       {string}        optionName
		 */
		_insertOptionToList: function (optionID, optionName) {
			var optionListDiv = elById('threadFormOptions');
			var optionList = elBySel('ol', optionListDiv);
			
			var liElement = elCreate('li');
			liElement.classList = 'sortableNode sortableNoNesting';
			elData(liElement, 'object-id', optionID);
			
			var spanElement = elCreate('span');
			spanElement.classList = 'sortableNodeLabel';
			
			var optionNameSpan = elCreate('span');
			optionNameSpan.textContent = optionName;
			spanElement.appendChild(optionNameSpan);
			
			var optionsSpan = elCreate('span');
			optionsSpan.classList = 'statusDisplay sortableButtonContainer';
			
			var editSpan = elCreate('span');
			editSpan.classList = 'icon icon16 fa-pencil pointer jsEditButton jsTooltip';
			editSpan.title = Language.get('wcf.global.button.edit');
			elData(editSpan, 'object-id', optionID);
			optionsSpan.appendChild(editSpan);
			
			var removeSpan = elCreate('span');
			removeSpan.classList = 'icon icon16 fa-times pointer jsDeleteButton jsTooltip';
			removeSpan.title = Language.get('wcf.global.button.delete');
			elData(removeSpan, 'object-id', optionID);
			optionsSpan.appendChild(removeSpan);
			
			spanElement.appendChild(optionsSpan);
			liElement.appendChild(spanElement);
			optionList.appendChild(liElement);
		},
		
		_ajaxSuccess: function (data) {
			if (data.actionName === 'create') {
				elShow(elById('threadFormOptions'));
				elHide(elById('threadFormNoOptionsInfo'));
				
				this._insertOptionToList(data.returnValues.optionID, data.returnValues.optionTitle);
				
				DialogHandler.closeDialog();
			}
		},
		
		_ajaxSetup: function () {
			return {
				data: {
					className: 'wbb\\data\\thread\\form\\option\\ThreadFormOptionAction',
					actionName: 'create'
				}
			};
		}
	};
});
