{capture assign='pageTitle'}{$__wcf->getActivePage()->getTitle()} - {$board->getTitle()}{/capture}

{include file='header'}

{if !$board->getPermission('canStartThreadWithoutModeration')}
	<p class="info" role="status">{lang}wbb.thread.moderation.info{/lang}</p>
{/if}

{include file='formError'}

<form id="messageContainer" class="jsFormGuard" method="post" action="{link application='wbb' controller='ThreadAdd' id=$boardID}{/link}">
	{include file='threadTypeSelection' application='wbb'}
	
	<section class="section">
		<h2 class="sectionTitle">{lang}wbb.post.information{/lang}</h2>
		
		{if !$__wcf->user->userID}
			<dl{if $errorField == 'username'} class="formError"{/if}>
				<dt><label for="username">{lang}wcf.user.username{/lang}</label> <span class="formFieldRequired">*</span></dt>
				<dd>
					<input type="text" id="username" name="username" value="{$username}" required class="long">
					{if $errorField == 'username'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wcf.user.username.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
		{/if}
		
		{event name='afterUsernameField'}
		
		{include file='messageFormMultilingualism'}
		
		{if $labelGroups && $labelGroups|count}
			{foreach from=$labelGroups item=labelGroup}
				{if $labelGroup|count}
					<dl{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset} class="formError"{/if}>
						<dt><label>{$labelGroup->getTitle()}</label>{if $labelGroup->forceSelection} <span class="formFieldRequired">*</span>{/if}</dt>
						<dd>
							<ul class="labelList jsOnly" data-object-id="{@$labelGroup->groupID}">
								<li class="dropdown labelChooser" id="labelGroup{@$labelGroup->groupID}" data-group-id="{@$labelGroup->groupID}" data-force-selection="{if $labelGroup->forceSelection}true{else}false{/if}">
									<div class="dropdownToggle" data-toggle="labelGroup{@$labelGroup->groupID}"><span class="badge label">{lang}wcf.label.none{/lang}</span></div>
									<div class="dropdownMenu">
										<ul class="scrollableDropdownMenu">
											{foreach from=$labelGroup item=label}
												<li data-label-id="{@$label->labelID}"><span>{@$label->render()}</span></li>
											{/foreach}
										</ul>
									</div>
								</li>
							</ul>
							<noscript>
								<select name="labelIDs[{@$labelGroup->groupID}]">
									{foreach from=$labelGroup item=label}
										<option value="{@$label->labelID}">{$label->getTitle()}</option>
									{/foreach}
								</select>
							</noscript>
							{if $errorField == 'label' && $errorType[$labelGroup->groupID]|isset}
								<small class="innerError">
									{if $errorType[$labelGroup->groupID] == 'missing'}
										{lang}wcf.label.error.missing{/lang}
									{else}
										{lang}wcf.label.error.invalid{/lang}
									{/if}
								</small>
							{/if}
						</dd>
					</dl>
				{/if}
			{/foreach}
		{/if}
		
		<dl{if $errorField == 'subject'} class="formError"{/if}>
			<dt><label for="subject">{lang}wbb.post.subject{/lang}</label> <span class="formFieldRequired">*</span></dt>
			<dd>
				<input type="text" id="subject" name="subject" value="{$subject}" required autofocus maxlength="255" class="long">
				{if $errorField == 'subject'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{elseif $errorType == 'censoredWordsFound'}
							{lang}wcf.message.error.censoredWordsFound{/lang}
						{else}
							{lang}wbb.post.subject.error.{@$errorType}{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		
		{if MODULE_TAGGING && WBB_THREAD_ENABLE_TAGS && $board->getPermission('canSetTags')}{include file='tagInput'}{/if}
		
		{if $board->getModeratorPermission('canEnableThread')}
			<dl>
				<dt></dt>
				<dd>
					<label><input type="checkbox" id="disableThread" name="disableThread" value="1"{if $disableThread} checked{/if}> {lang}wbb.post.disableThread{/lang}</label>
				</dd>
			</dl>
			
			<dl{if $errorField == 'enableTime'} class="formError"{/if}{if !$disableThread} style="display: none"{/if}>
				<dt><label for="enableTime">{lang}wbb.post.enableTime{/lang}</label></dt>
				<dd>
					<input type="datetime" id="enableTime" name="enableTime" value="{$enableTime}" class="medium">
					{if $errorField == 'enableTime'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}wbb.post.enableTime.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
					<small>{lang}wbb.post.enableTime.description{/lang}</small>
				</dd>
			</dl>
			
			<script data-relocate="true">
				$(function() {
					$('#disableThread').click(function() {
						$('#enableTime').parents('dl:eq(0)').toggle();
					});
					
					$('#messageContainer').submit(function() {
						if (!$('#disableThread').is(':checked')) {
							$('#enableTime').datepicker('destroy');
							$('input[name=enableTime]').val('');
						}
					});
				});
			</script>
		{/if}
		
		{event name='informationFields'}
	</section>
	
	{include file='captcha' supportsAsyncCaptcha=true}
	
	{hascontent}
		<section class="section">
			<h2 class="sectionTitle">{if $threadForm}{$threadForm->getTitle()}{else}{lang}wbb.thread.threadForm.title{/lang}{/if}</h2>
			
			{content}
				{include file='customOptionFieldList'}
				
				{event name='optionFields'}
			{/content}
		</section>
	{/hascontent}
	
	{event name='beforeMessageFieldset'}
	
	<section class="section">
		<h2 class="sectionTitle">{lang}wbb.post.message{/lang}</h2>
		
		<dl class="wide{if $errorField == 'text'} formError{/if}">
			<dt><label for="text">{lang}wbb.post.message{/lang}</label> <span class="formFieldRequired">*</span></dt>
			<dd>
				<textarea id="text" name="text" class="wysiwygTextarea"
				          data-autosave="com.woltlab.wbb.threadAdd-{@$board->boardID}"
				          data-support-mention="true"
				>{$text}</textarea>
				{if $errorField == 'text'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{elseif $errorType == 'tooLong'}
							{lang}wcf.message.error.tooLong{/lang}
						{elseif $errorType == 'censoredWordsFound'}
							{lang}wcf.message.error.censoredWordsFound{/lang}
						{elseif $errorType == 'disallowedBBCodes'}
							{lang}wcf.message.error.disallowedBBCodes{/lang}
						{else}
							{lang}wbb.post.message.error.{@$errorType}{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		
		{event name='messageFields'}
	</section>
	
	{include file='messageFormTabs' wysiwygContainerID='text'}
	
	{event name='sections'}
	
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{include file='messageFormPreviewButton' previewMessageObjectType='com.woltlab.wbb.post' previewMessageObjectID=0}
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

<div class="section">
	<p><span class="formFieldRequired">*</span> {lang}wcf.contact.options.required{/lang}</p>
</div>

<script data-relocate="true">
	$(function() {
		WCF.Language.addObject({
			'wcf.label.none': '{jslang}wcf.label.none{/jslang}'
		});
		
		new WCF.Label.Chooser({ {implode from=$labelIDs key=groupID item=labelID}{@$groupID}: {@$labelID}{/implode} }, '#messageContainer');
		{if WBB_THREAD_SHOW_SIMILAR_THREADS_WHEN_CREATING_NEW_THREAD}
		new WBB.Thread.SimilarThreads($('#subject'), {@$board->boardID});
		{/if}
		
		WCF.Message.Submit.registerButton('text', $('#messageContainer > .formSubmit > input[type=submit]'));
		new WCF.Message.FormGuard();
		
		{include file='__messageQuoteManager' wysiwygSelector='text' supportPaste=true}
		
		WCF.System.Dependency.Manager.register('Redactor_text', function() { new WCF.Message.UserMention('text'); });
	});
</script>

{include file='wysiwyg'}
{include file='footer'}
