{capture assign='pageTitle'}{$board->getTitle()}{if $pageNo > 1} - {lang}wcf.page.pageNo{/lang}{/if}{/capture}

{capture assign='contentHeader'}
	<header class="contentHeader">
		<div class="contentHeaderTitle">
			<h1 class="contentTitle">{$board->getTitle()}</h1>
			{hascontent}<p class="contentHeaderDescription">{content}{if $board->descriptionUseHtml}{@$board->description|language}{else}{$board->description|language}{/if}{/content}</p>{/hascontent}
		</div>
		
		{hascontent}
			<nav class="contentHeaderNavigation">
				<ul>
					{content}
						{if $board->isBoard()}
							{if $board->canStartThread()}<li><a href="{link application='wbb' controller='ThreadAdd' id=$boardID}{/link}" title="{lang}wbb.thread.add{/lang}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.thread.button.add{/lang}</span></a></li>{/if}
						{/if}
						{event name='contentHeaderNavigation'}
					{/content}
				</ul>
			</nav>
		{/hascontent}
	</header>
{/capture}

{capture assign='headContent'}
	{if $board->isBoard()}
		{if $__wcf->getUser()->userID}
			<link rel="alternate" type="application/rss+xml" title="{lang}wcf.global.button.rss{/lang}" href="{link application='wbb' controller='BoardFeed' id=$board->boardID}at={@$__wcf->getUser()->userID}-{@$__wcf->getUser()->accessToken}{/link}">
		{else}
			<link rel="alternate" type="application/rss+xml" title="{lang}wcf.global.button.rss{/lang}" href="{link application='wbb' controller='BoardFeed' id=$board->boardID}{/link}">
		{/if}
		
		{assign var='additionalLinkParameters' value=''}
		{if $filterByDate != $defaultFilterByDate}{append var='additionalLinkParameters' value="&filterByDate=$filterByDate"}{/if}
		{if $filterByStatus}{append var='additionalLinkParameters' value="&filterByStatus=$filterByStatus"}{/if}
		{if $labelIDs|count}{capture append='additionalLinkParameters'}{foreach from=$labelIDs key=labelGroupID item=labelID}&labelIDs[{@$labelGroupID}]={@$labelID}{/foreach}{/capture}{/if}
		{if $languageID}{append var='additionalLinkParameters' value="&languageID=$languageID"}{/if}
		{if $tagID}{append var='additionalLinkParameters' value="&tagID=$tagID"}{/if}
		{capture assign='canonicalURLParameters'}{if $sortField != $defaultSortField}&sortField={@$sortField}{/if}{if $sortOrder != $defaultSortOrder}&sortOrder={@$sortOrder}{/if}{@$additionalLinkParameters}{/capture}
		
		{if $pageNo < $pages}
			<link rel="next" href="{link application='wbb' controller='Board' object=$board}pageNo={@$pageNo+1}{@$canonicalURLParameters}{/link}">
		{/if}
		{if $pageNo > 1}
			<link rel="prev" href="{link application='wbb' controller='Board' object=$board}{if $pageNo > 2}pageNo={@$pageNo-1}{@$canonicalURLParameters}{else}{@$canonicalURLParameters|substr:1}{/if}{/link}">
		{/if}
	{/if}
{/capture}

{if $board->isBoard()}
	{capture assign='sidebarRight'}
		{include file='boardSidebar' application='wbb'}
	{/capture}
{/if}

{if $board->isBoard()}
	{capture assign='headerNavigation'}
		<li><a rel="alternate" href="{if $__wcf->getUser()->userID}{link application='wbb' controller='BoardFeed' id=$board->boardID}at={@$__wcf->getUser()->userID}-{@$__wcf->getUser()->accessToken}{/link}{else}{link application='wbb' controller='BoardFeed' id=$board->boardID}{/link}{/if}" title="{lang}wcf.global.button.rss{/lang}" class="jsTooltip"><span class="icon icon16 fa-rss"></span> <span class="invisible">{lang}wcf.global.button.rss{/lang}</span></a></li>
		{if $__wcf->user->userID && !$board->isPrivate}
			<li class="jsOnly"><a href="#" title="{lang}wcf.user.objectWatch.manageSubscription{/lang}" class="jsSubscribeButton jsTooltip" data-object-type="com.woltlab.wbb.board" data-object-id="{@$board->boardID}" data-is-subscribed="{if $board->isSubscribed()}true{else}false{/if}"><span class="icon icon16 fa-bookmark{if !$board->isSubscribed()}-o{/if}"></span> <span class="invisible">{lang}wcf.user.objectWatch.manageSubscription{/lang}</span></a></li>
		{/if}
		<li class="jsOnly"><a href="#" title="{lang}wbb.board.markAsRead{/lang}" class="markAsReadButton jsTooltip"><span class="icon icon16 fa-check"></span> <span class="invisible">{lang}wbb.board.markAsRead{/lang}</span></a></li>
	{/capture}
{/if}

{capture assign='__pageDataAttributes'}data-board-id="{@$board->boardID}"{/capture}

{include file='header'}

{if $boardNodeList->valid()}
	{include file='boardNodeListContainer' application='wbb'}
{/if}

{if $board->isBoard()}
	{hascontent}
		<div class="paginationTop">
			{content}{pages print=true assign=pagesLinks application='wbb' controller='Board' object=$board link="pageNo=%d$canonicalURLParameters"}{/content}
		</div>
	{/hascontent}
	
	{if $objects|count}
		{include file='boardThreadList' application='wbb'}
	{else}
		<p class="info" role="status">{lang}wbb.board.noThreads{/lang}</p>
		
		<div class="jsClipboardContainer" data-type="com.woltlab.wbb.thread"></div>
	{/if}
	
	{include file='boardThreadListFilter' application='wbb'}
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}
		
		{hascontent}
			<nav class="contentFooterNavigation">
				<ul>
					{content}
						{if $board->canStartThread()}<li><a href="{link application='wbb' controller='ThreadAdd' id=$boardID}{/link}" title="{lang}wbb.thread.add{/lang}" class="button"><span class="icon icon16 fa-plus"></span> <span>{lang}wbb.thread.button.add{/lang}</span></a></li>{/if}
						{event name='contentFooterNavigation'}
					{/content}
				</ul>
			</nav>
		{/hascontent}
	</footer>
{/if}

{capture assign='footerBoxes'}
	{if WBB_BOARD_ENABLE_STATS && $board->isBoard() && $__wcf->session->getPermission('user.profile.canViewStatistics')}
		<section class="box">
			<h2 class="boxTitle">{lang}wbb.index.stats{/lang}</h2>
			
			<div class="boxContent">
				{lang}wbb.board.stats.detail{/lang}
			</div>
		</section>
	{/if}
	
	{event name='infoBoxes'}
{/capture}

<script data-relocate="true">
	$(function() {
		WCF.Language.addObject({
			'wbb.post.copy.title': '{jslang}wbb.post.copy.title{/jslang}',
			'wbb.post.moveToNewThread': '{jslang}wbb.post.moveToNewThread{/jslang}',
			'wbb.thread.closed': '{jslang}wbb.thread.closed{/jslang}',
			'wbb.thread.confirmDelete': '{jslang}wbb.thread.confirmDelete{/jslang}',
			'wbb.thread.confirmTrash': '{jslang}wbb.thread.confirmTrash{/jslang}',
			'wbb.thread.confirmTrash.reason': '{jslang}wbb.thread.confirmTrash.reason{/jslang}',
			'wbb.thread.copy.title': '{jslang __literal=true}wbb.thread.copy.title{/jslang}',
			'wbb.thread.done': '{jslang}wbb.thread.done{/jslang}',
			'wbb.thread.edit.advanced': '{jslang}wbb.thread.edit.advanced{/jslang}',
			'wbb.thread.edit.assignLabel': '{jslang}wbb.thread.edit.assignLabel{/jslang}',
			'wbb.thread.edit.close': '{jslang}wbb.thread.edit.close{/jslang}',
			'wbb.thread.edit.delete': '{jslang}wbb.thread.edit.delete{/jslang}',
			'wbb.thread.edit.done': '{jslang}wbb.thread.edit.done{/jslang}',
			'wbb.thread.edit.enable': '{jslang}wbb.thread.edit.enable{/jslang}',
			'wbb.thread.edit.disable': '{jslang}wbb.thread.edit.disable{/jslang}',
			'wbb.thread.edit.merge': '{jslang}wbb.thread.edit.merge{/jslang}',
			'wbb.thread.edit.merge.success': '{jslang}wbb.thread.edit.merge.success{/jslang}',
			'wbb.thread.edit.move': '{jslang}wbb.thread.edit.move{/jslang}',
			'wbb.thread.edit.open': '{jslang}wbb.thread.edit.open{/jslang}',
			'wbb.thread.edit.removeLink': '{jslang}wbb.thread.edit.removeLink{/jslang}',
			'wbb.thread.edit.restore': '{jslang}wbb.thread.edit.restore{/jslang}',
			'wbb.thread.edit.scrape': '{jslang}wbb.thread.edit.scrape{/jslang}',
			'wbb.thread.edit.sticky': '{jslang}wbb.thread.edit.sticky{/jslang}',
			'wbb.thread.edit.trash': '{jslang}wbb.thread.edit.trash{/jslang}',
			'wbb.thread.edit.undone': '{jslang}wbb.thread.edit.undone{/jslang}',
			'wbb.thread.moved': '{jslang}wbb.thread.moved{/jslang}',
			'wbb.thread.sticky': '{jslang}wbb.thread.sticky{/jslang}',
			'wbb.thread.undone': '{jslang}wbb.thread.undone{/jslang}',
			'wbb.thread.edit.moveThreads': '{jslang}wbb.thread.edit.moveThreads{/jslang}',
			'wbb.thread.edit': '{jslang}wbb.thread.edit{/jslang}',
			'wcf.global.worker.completed': '{jslang}wcf.global.worker.completed{/jslang}',
			'wcf.user.objectWatch.manageSubscription' : '{jslang}wcf.user.objectWatch.manageSubscription{/jslang}'
		});
		
		var $updateHandler = new WBB.Thread.UpdateHandler.Board();
		var $inlineEditor = new WBB.Thread.InlineEditor('.wbbThread');
		$inlineEditor.setUpdateHandler($updateHandler);
		$inlineEditor.setEnvironment('board', {@$board->boardID}, '{link application='wbb' controller='Board' object=$board encode=false}{/link}');
		$inlineEditor.setPermissions({
			canCloseThread: {if $board->getModeratorPermission('canCloseThread')}true{else}false{/if},
			canDeleteThread: {if $board->getModeratorPermission('canDeleteThread')}true{else}false{/if},
			canDeleteThreadCompletely: {if $board->getModeratorPermission('canDeleteThreadCompletely')}true{else}false{/if},
			canEnableThread: {if $board->getModeratorPermission('canEnableThread')}true{else}false{/if},
			canMoveThread: {if $board->getModeratorPermission('canMoveThread')}true{else}false{/if},
			canPinThread: {if $board->getModeratorPermission('canPinThread')}true{else}false{/if},
			canRestoreThread: {if $board->getModeratorPermission('canRestoreThread')}true{else}false{/if}
		});
		
		var $threadClipboard = new WBB.Thread.Clipboard($updateHandler, 'board', {@$board->boardID});
		var $postClipboard = new WBB.Post.Clipboard(null);
		WCF.Clipboard.init('wbb\\page\\BoardPage', {@$hasMarkedItems}, { }, {@$board->boardID});
		
		{if WBB_MODULE_THREAD_MARKING_AS_DONE && $board->enableMarkingAsDone}
			new WBB.Thread.MarkAsDone($updateHandler);
		{/if}
		new WBB.Thread.MarkAsRead();
		new WBB.Board.MarkAllThreadsAsRead({@$board->boardID});
		
		var $options = { };
		{if $pages > 1}
			$options.refreshPage = true;
			{if $pages == $pageNo}
				$options.updatePageNumber = -1;
			{/if}
		{elseif $hasActiveFilter}
			$options.emptyMessageHtml = '{jslang}wbb.board.noThreads{/jslang}';
		{else}
			$options.emptyMessage = '{jslang}wbb.board.noThreads{/jslang}';
		{/if}
		
		new WCF.Table.EmptyTableHandler($('.wbbThreadList'), 'wbbThread', $options);
		
		{if $__wcf->user->userID}
			new WCF.User.ObjectWatch.Subscribe();
		{/if}
		
		require(['WoltLabSuite/Forum/Ui/Mobile'], function(WbbUiMobile) {
			WbbUiMobile.init();
		});
	});
</script>

{include file='footer'}
