{if $posts|count > 0 || $thread->canReply()}
	<section id="comments" class="section sectionContainerList">
		<h2 class="sectionTitle">{lang}wbb.thread.article.replies.title{/lang}{if $thread->replies} <span class="badge">{#$thread->replies}</span>{/if}</h2>
		
		<ul class="commentList containerList wbbArticlePostList">
			{if $thread->canReply()}
				<li class="box48">
					{@$__wcf->getUserProfileHandler()->getAvatar()->getImageTag(48)}
					<a href="{link application='wbb' controller='Thread' object=$thread}#messageQuickReply{/link}" class="wbbArticleReply">{lang}wbb.thread.article.reply{/lang}</a>
				</li>
			{/if}
			
			{foreach from=$posts item=post}
				<li class="comment">
					<div class="box48">
						{if $post->userID}
							{user object=$post->getUserProfile() type='avatar48' ariaHidden='true'}
						{else}
							<span>{@$post->getUserProfile()->getAvatar()->getImageTag(48)}</span>
						{/if}
						
						<div class="commentContentContainer" itemid="{link application='wbb' controller='Thread' object=$thread postID=$post->postID}{/link}" itemscope itemtype="http://schema.org/DiscussionForumPosting">
							<div class="commentContent">
								<meta itemprop="dateCreated" content="{@$post->time|date:'c'}">
								
								<div class="containerHeadline">
									<h3 itemprop="author" itemscope itemtype="http://schema.org/Person">
										{if $post->userID}
											<a href="{$post->getUserProfile()->getLink()}" class="username userLink" data-object-id="{@$post->userID}">
												<span itemprop="name">{@$post->getUserProfile()->getFormattedUsername()}</span>
											</a>
										{else}
											<span class="username" itemprop="name">{$post->username}</span>
										{/if}
										<small class="separatorLeft">
											<a href="{link application='wbb' controller='Thread' object=$thread postID=$post->postID}{/link}" class="permalink messagePublicationTime">{@$post->time|time}</a>
										</small>
										{if MODULE_LIKE && $__wcf->getSession()->getPermission('user.like.canViewLike') && ($post->likes || $post->dislikes)}
											<span class="separatorLeft wcfLikeCounter{if $post->cumulativeLikes > 0} likeCounterLiked{elseif $post->cumulativeLikes < 0}likeCounterDisliked{/if}"><span class="icon icon16 fa-thumbs-o-{if $post->cumulativeLikes < 0}down{else}up{/if} jsTooltip" title="{lang likes=$post->likes dislikes=$post->dislikes}wcf.like.tooltip{/lang}"></span><span class="wcfLikeValue">{if $post->cumulativeLikes > 0}+{elseif $post->cumulativeLikes == 0}&plusmn;{/if}{#$post->cumulativeLikes}</span></span>
										{/if}
									</h3>
								</div>
								
								<div class="htmlContent userMessage">
									{@$post->getFormattedMessage()}
								</div>
								
								{if MODULE_LIKE}{include file="reactionSummaryList" isTiny=true reactionData=$likeData objectType="com.woltlab.wbb.likeablePost" objectID=$post->postID}{/if}
							</div>
						</div>
					</div>
				</li>
			{/foreach}
			
			{if $posts|count > 0}
				<li class="wbbArticleGoToThread">
					<a href="{link application='wbb' controller='Thread' object=$thread}{/link}" class="button buttonPrimary">
						<span class="wbbArticleJoinTheDiscussion">{lang}wbb.thread.article.joinTheDiscussion{/lang}</span>
						{if $moreReplies}<small class="wbbArticleMoreReplies">{lang}wbb.thread.article.moreReplies{/lang}</small>{/if}
					</a>
					
				</li>
			{/if}
		</ul>
	</section>
{/if}
