require(['WoltLabSuite/Core/Controller/Popover'], function(ControllerPopover) {
	ControllerPopover.init({
		className: 'wbbTopicLink',
		dboAction: 'wbb\\data\\thread\\ThreadAction',
		identifier: 'com.woltlab.wbb.thread',
		loadCallback: function(objectId, popover, element) {
			var callback = function(data) {
				popover.setContent(
					'com.woltlab.wbb.thread',
					objectId,
					data.returnValues.template
				);
			}.bind(this);
			
			popover.ajaxApi({
				actionName: 'getPopover',
				className: 'wbb\\data\\thread\\ThreadAction',
				objectIDs: [ objectId ],
				parameters: {
					sortOrder: elData(element, 'sort-order') ? elData(element, 'sort-order') : 'ASC'
				}
			}, callback, callback);
		}
	});
	
	// @deprecated 5.3 use `data-object-id` or `anchor` template plugin
	ControllerPopover.init({
		attributeName: 'data-thread-id',
		className: 'wbbTopicLink',
		identifier: 'com.woltlab.wbb.thread.deprecated',
		loadCallback: function(objectId, popover, element) {
			var callback = function(data) {
				popover.setContent(
					'com.woltlab.wbb.thread.deprecated',
					objectId,
					data.returnValues.template
				);
			}.bind(this);
			
			popover.ajaxApi({
				actionName: 'getPopover',
				className: 'wbb\\data\\thread\\ThreadAction',
				objectIDs: [ objectId ],
				parameters: {
					sortOrder: elData(element, 'sort-order') ? elData(element, 'sort-order') : 'ASC'
				}
			}, callback, callback);
		}
	});
	
	ControllerPopover.init({
		className: 'wbbPostLink',
		dboAction: 'wbb\\data\\post\\PostAction',
		identifier: 'com.woltlab.wbb.post'
	});
	
	// @deprecated 5.3 use `data-object-id` or `anchor` template plugin
	ControllerPopover.init({
		attributeName: 'data-post-id',
		className: 'wbbPostLink',
		dboAction: 'wbb\\data\\post\\PostAction',
		identifier: 'com.woltlab.wbb.post.deprecated'
	});
});

{if $templateName == 'searchResult' && $searchData|isset && $searchData[additionalData]['com.woltlab.wbb.post'][findThreads]|isset}
	new WBB.Board.MarkAllAsRead(function() {
		window.location = '{link application='wbb' controller='BoardList'}{/link}';
	});
{/if}
