<?php
namespace calendar\system\event\listener;
use calendar\data\event\date\ViewableEventDate;
use wbb\page\ThreadPage;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Displays the event date box on thread page.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Calendar\System\Event\Listener
 */
class ThreadPageListener implements IParameterizedEventListener {
	/**
	 * event date object
	 * @var	ViewableEventDate
	 */
	protected $eventDate;
	
	/**
	 * event date participation
	 * @var	array
	 */
	protected $participation = [
		'yes' => 0,
		'no' => 0,
		'maybe' => 0
	];
	
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		/** @var ThreadPage $eventObj */
		
		switch ($eventName) {
			case 'assignVariables':
				if ($this->eventDate !== null) {
					WCF::getTPL()->assign([
						'calendarEventDate' => $this->eventDate,
						'calendarEventDateParticipation' => $this->participation
					]);
				}
				break;
				
			case 'readData':
				$sql = "SELECT	eventID
					FROM	calendar".WCF_N."_event
					WHERE	eventThreadID = ?";
				$statement = WCF::getDB()->prepareStatement($sql);
				$statement->execute([$eventObj->threadID]);
				$eventID = $statement->fetchSingleColumn();
				
				if ($eventID) {
					// get upcoming or ongoing event date
					$sql = "SELECT		eventDateID
						FROM		calendar".WCF_N."_event_date
						WHERE		eventID = ?
								AND (
									startTime >= ?
									OR endTime >= ?
								)
						ORDER BY	startTime";
					$statement = WCF::getDB()->prepareStatement($sql, 1);
					$statement->execute([
						$eventID,
						TIME_NOW,
						TIME_NOW
					]);
					$eventDateID = $statement->fetchSingleColumn();
					
					// last event date is in the past
					if (!$eventDateID) {
						$sql = "SELECT		eventDateID
							FROM		calendar".WCF_N."_event_date
							WHERE		eventID = ?
							ORDER BY	startTime DESC";
						$statement = WCF::getDB()->prepareStatement($sql, 1);
						$statement->execute([$eventID]);
						$eventDateID = $statement->fetchSingleColumn();
					}
					
					if ($eventDateID) {
						$this->eventDate = ViewableEventDate::getEventDate($eventDateID);
						
						// get participation overview
						if ($this->eventDate->getEvent()->enableParticipation) {
							$sql = "SELECT		COUNT(*) AS count, decision
								FROM		calendar".WCF_N."_event_date_participation
								WHERE		eventDateID = ?
								GROUP BY	decision";
							$statement = WCF::getDB()->prepareStatement($sql);
							$statement->execute([$this->eventDate->eventDateID]);
							while ($row = $statement->fetchArray()) {
								$this->participation[$row['decision']] = $row['count'];
							}
						}
					}
				}
				break;
		}
	}
}
