<?php
namespace calendar\system\event\listener;
use calendar\page\EventPage;
use wbb\data\thread\Thread;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\WCF;

/**
 * Gets the event thread of a calendar event.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Calendar\System\Event\Listener
 */
class EventPageEventThreadListener implements IParameterizedEventListener {
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		/** @var EventPage $eventObj */
		
		if ($eventObj->event->eventThreadID) {
			WCF::getTPL()->assign([
				'eventThread' => new Thread($eventObj->event->eventThreadID)
			]);
		}
	}
}
