<?php
namespace calendar\system\event\listener;
use wbb\data\board\BoardCache;
use wbb\data\board\BoardNodeList;
use wcf\acp\form\AbstractCategoryEditForm;
use wcf\system\event\listener\IParameterizedEventListener;
use wcf\system\exception\UserInputException;
use wcf\system\WCF;

/**
 * Handles individual board selection for each category.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Calendar\System\Event\Listener
 */
class CategoryEventThreadBoardListener implements IParameterizedEventListener {
	/**
	 * board id
	 * @var	integer
	 */
	protected $boardID = 0;
	
	/**
	 * board node list
	 * @var	BoardNodeList
	 */
	protected $boardNodeList;
	
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if (CALENDAR_EVENT_THREAD_SINGLE_BOARD) {
			return;
		}
		
		if ($this->boardNodeList === null) {
			$this->boardNodeList = new BoardNodeList();
			$this->boardNodeList->readNodeTree();
		}
		
		switch ($eventName) {
			case 'assignVariables':
				WCF::getTPL()->assign([
					'eventThreadBoardNodeList' => $this->boardNodeList->getNodeList(),
					'eventThreadBoardID' => $this->boardID
				]);
			break;
			
			case 'readData':
				if (empty($_POST) && $eventObj instanceof AbstractCategoryEditForm) {
					$this->boardID = ($eventObj->category->eventThreadBoardID ?: 0);
				}
			break;
			
			case 'save':
				$eventObj->additionalData['eventThreadBoardID'] = $this->boardID;
			break;
			
			case 'validate':
				$this->boardID = (!empty($_POST['eventThreadBoardID'])) ? intval($_POST['eventThreadBoardID']) : 0;
				if ($this->boardID) {
					$board = BoardCache::getInstance()->getBoard($this->boardID);
					if ($board === null || !$board->isBoard()) {
						throw new UserInputException('eventThreadBoardID', 'invalid');
					}
				}
			break;
		}
	}
}
