<?php
namespace calendar\data\event\date;
use calendar\data\event\date\participation\ViewableEventDateParticipationList;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\WCF;

/**
 * Executes event date-related actions for the WoltLab Suite Forum integration.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Calendar\Data\Event\Date
 */
class EventDateThreadAction extends EventDateAction {
	/**
	 * @inheritDoc
	 */
	protected $allowGuestAccess = ['getCompactParticipationList'];
	
	/**
	 * Validates parameters to fetch the compact participation list.
	 */
	public function validateGetCompactParticipationList() {
		$this->eventDateEditor = $this->getSingleObject();
		if (!$this->eventDateEditor->canViewParticipationList()) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * Returns the compact participation list.
	 * 
	 * @return	string[]
	 */
	public function getCompactParticipationList() {
		$participantList = new ViewableEventDateParticipationList();
		$participantList->getConditionBuilder()->add('eventDateID = ?', [$this->eventDateEditor->eventDateID]);
		$participantList->readObjects();
		
		WCF::getTPL()->assign([
			'eventDate' => $this->eventDateEditor,
			'participantList' => $participantList
		]);
		
		return [
			'template' => WCF::getTPL()->fetch('eventDateParticipationListCompact', 'calendar')
		];
	}
}
