/**
 * Class and function collection for WoltLab Calendar Event Thread
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 */

Calendar.Event.Thread = { };

/**
 * Manages the event date box for threads.
 */
Calendar.Event.Thread.ShowParticipants = Class.extend({
	/**
	 * participation lists container
	 * @var	jQuery
	 */
	_container: null,
	
	/**
	 * event date id
	 * @var	integer
	 */
	_eventDateID: 0,
	
	/**
	 * Initializes the Calendar.Event.Thread.ShowParticipants class.
	 * 
	 * @param	integer		eventDateID
	 */
	init: function(eventDateID) {
		this._container = null;
		this._eventDateID = eventDateID;
		
		$('.jsCalendarEventDateShowParticipants').click(this.toggle.bind(this));
	},
	
	/**
	 * Toggles the participation list.
	 * 
	 * @param	object		event
	 */
	toggle: function(event) {
		event.preventDefault();
		
		if (this._container === null) {
			new WCF.Action.Proxy({
				autoSend: true,
				data: {
					actionName: 'getCompactParticipationList',
					className: 'calendar\\data\\event\\date\\EventDateThreadAction',
					objectIDs: [ this._eventDateID ]
				},
				success: this._success.bind(this)
			});
		}
		else {
			this._container.toggleClass('hidden');
		}
	},
	
	/**
	 * Handles successful AJAX requests.
	 * 
	 * @param	object		data
	 */
	_success: function(data) {
		this._container = $('<div class="calendarEventThreadBoxParticipants" />').html(data.returnValues.template);
		this._container.appendTo($('#calendarEventThreadBox'));
	}
});